import { TemplateContext } from 'typescript-template-language-service-decorator';
import * as vscode from 'vscode-languageserver-types';
/**
 * Handles mapping between template contents to virtual documents.
 */
export interface VirtualDocumentProvider {
    createVirtualDocument(context: TemplateContext): vscode.TextDocument;
    toVirtualDocPosition(position: ts.LineAndCharacter): ts.LineAndCharacter;
    fromVirtualDocPosition(position: ts.LineAndCharacter): ts.LineAndCharacter;
    toVirtualDocOffset(offset: number): number;
    fromVirtualDocOffset(offset: number): number;
}
/**
 * Standard virtual document provider for styled content.
 *
 * Wraps content in a top level `:root { }` rule to make css language service happy
 * since styled allows properties to be top level elements.
 */
export declare class StyledVirtualDocumentFactory implements VirtualDocumentProvider {
    private static readonly wrapperPre;
    createVirtualDocument(context: TemplateContext): vscode.TextDocument;
    toVirtualDocPosition(position: ts.LineAndCharacter): ts.LineAndCharacter;
    fromVirtualDocPosition(position: ts.LineAndCharacter): ts.LineAndCharacter;
    toVirtualDocOffset(offset: number): number;
    fromVirtualDocOffset(offset: number): number;
}
