/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class ReorderConstantExpression
extends AbstractPeepholeOptimization {
    ReorderConstantExpression() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        if (NodeUtil.isSymmetricOperation(subtree) || NodeUtil.isRelationalOperation(subtree)) {
            if (NodeUtil.precedence(subtree.getType()) == NodeUtil.precedence(subtree.getFirstChild().getType())) {
                return subtree;
            }
            if (NodeUtil.isImmutableValue(subtree.getLastChild()) && !NodeUtil.isImmutableValue(subtree.getFirstChild())) {
                if (NodeUtil.isRelationalOperation(subtree)) {
                    int inverseOperator = NodeUtil.getInverseOperator(subtree.getType());
                    subtree.setType(inverseOperator);
                }
                Node firstNode = subtree.getFirstChild().detachFromParent();
                Node lastNode = subtree.getLastChild().detachFromParent();
                subtree.addChildrenToFront(lastNode);
                subtree.addChildrenToBack(firstNode);
                this.reportCodeChange();
            }
        }
        return subtree;
    }
}

