/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ClaimType {
    FULL(0, "Full", "Full"),
    AMOUNT(1, "Amount", "Amount"),
    AMOUNT_OFFSET(2, "AmountOffset", "AmountOffset");

    public static final int FULL_VALUE = 0;
    public static final int AMOUNT_VALUE = 1;
    public static final int AMOUNT_OFFSET_VALUE = 2;
    private static final ClaimType[] VALUES_ARRAY;
    public static final List<ClaimType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClaimType[]{FULL, AMOUNT, AMOUNT_OFFSET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClaimType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClaimType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClaimType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClaimType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClaimType get(int value) {
        switch (value) {
            case 0: {
                return FULL;
            }
            case 1: {
                return AMOUNT;
            }
            case 2: {
                return AMOUNT_OFFSET;
            }
        }
        return null;
    }

    private ClaimType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

