/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl.cmd;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.io.ParseException;
import org.eclipse.trace4cps.core.io.TraceReader;
import org.eclipse.trace4cps.tl.EtlStandaloneSetup;
import org.eclipse.trace4cps.tl.FormulaBuilderException;
import org.eclipse.trace4cps.tl.VerificationHelper;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class Verify {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;

    private static int exitError(String msg) {
        System.out.println(msg);
        return -1;
    }

    private static void showUsage() {
        System.out.println("Usage: verify <.etl spec file> <.etf trace file>");
    }

    public static void main(String[] args) {
        int exitCode = Verify.doMain(args);
        System.exit(exitCode);
    }

    public static int doMain(String[] args) {
        if (args.length != 2) {
            Verify.showUsage();
            return Verify.exitError("Please provide the proper arguments.");
        }
        File specFile = new File(args[0]);
        File traceFile = new File(args[1]);
        if (!specFile.exists() || specFile.isDirectory()) {
            Verify.showUsage();
            return Verify.exitError("The provided specification file does not exist.");
        }
        if (!traceFile.exists() || traceFile.isDirectory()) {
            Verify.showUsage();
            return Verify.exitError("The provided trace file does not exist.");
        }
        Injector injector = new EtlStandaloneSetup().createInjectorAndDoEMFRegistration();
        Verify verify = (Verify)injector.getInstance(Verify.class);
        try {
            int exitCode = verify.run(specFile, traceFile);
            if (exitCode < 0) {
                return Verify.exitError("Syntax errors or validation errors in model.");
            }
            return exitCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Verify.exitError(e.getMessage());
        }
    }

    private int run(File specFile, File traceFile) throws FormulaBuilderException, InterruptedException, ExecutionException, ParseException, IOException {
        ITrace trace = TraceReader.readTrace(traceFile);
        Resource resource = this.getValidatedResource(specFile.getAbsolutePath());
        if (resource == null) {
            return -1;
        }
        EtlModel model = (EtlModel)resource.getContents().get(0);
        VerificationHelper vh = new VerificationHelper(trace, model);
        return this.printResult(vh.run());
    }

    private Resource getValidatedResource(String filename) {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)filename), true);
        IResourceValidator validator = ((XtextResource)resource).getResourceServiceProvider().getResourceValidator();
        List issues = validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        for (Issue issue : issues) {
            if (issue.getSeverity() != Severity.ERROR) continue;
            return null;
        }
        return resource;
    }

    private int printResult(VerificationResult verRes) {
        int unsatCount = 0;
        for (MtlFormula phi : verRes.getChecks()) {
            InformativePrefix p;
            String index = "";
            if (verRes.isQuantifiedCheck(phi)) {
                index = "[" + verRes.getQuantifierValue(phi) + "]";
            }
            if ((p = verRes.getResult(phi).informative()) != InformativePrefix.BAD) continue;
            System.out.println(verRes.getName(phi) + index + " : " + (Object)((Object)p));
            ++unsatCount;
        }
        System.out.println("#UNSAT = " + unsatCount);
        return unsatCount;
    }
}

