/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfigurationIO;

public class SaveViewConfigurationAction
extends AbstractTraceViewAction {
    public SaveViewConfigurationAction(TraceView view) {
        super(view, "/icons/save_edit.png");
        this.setToolTipText("Save view configuration");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1;
    }

    @Override
    protected void doRun() throws TraceException {
        File file = this.view.getViewConfigFile(0);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SaveViewConfigurationAction.this.viewCfg.setRange(SaveViewConfigurationAction.this.view.getDomainAxisRange());
                }
            });
            TraceViewConfigurationIO.toFile((TraceViewConfiguration)this.viewCfg, (File)file);
        }
        catch (IOException | InterruptedException | InvocationTargetException e) {
            throw new TraceException("Failed to write configuration file", (Throwable)e);
        }
    }
}

