/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.HashMap;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.ColorManager;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsConfiguration;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsDocumentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SuppressionsEditor
extends TextEditor {
    private ColorManager colorManager = new ColorManager();
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private Annotation[] oldAnnotations;

    public SuppressionsEditor() {
        this.setSourceViewerConfiguration(new SuppressionsConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new SuppressionsDocumentProvider());
        this.oldAnnotations = null;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(Position[] updatedPositions) {
        Annotation[] updatedAnnotations = new Annotation[updatedPositions.length];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < updatedPositions.length) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, updatedPositions[i]);
            updatedAnnotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = updatedAnnotations;
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }
}

