/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IImage;

public class HotSpot
extends GraphNode {
    protected BasicExecutionOccurrence execOcc = null;
    protected int occurrence = 0;
    protected IImage image = null;
    public static final String GLYPH = "Glyph";

    public HotSpot() {
        this.prefId = "PREF_EXEC";
    }

    public void setImage(IImage img) {
        this.image = img;
    }

    @Override
    public int getX() {
        if (this.execOcc != null) {
            return this.execOcc.getX() - 3;
        }
        return 0;
    }

    @Override
    public int getY() {
        if (this.execOcc != null) {
            return this.execOcc.getY();
        }
        return 0;
    }

    @Override
    public int getWidth() {
        if (this.execOcc != null) {
            return this.execOcc.getWidth() + 7;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.execOcc != null) {
            return this.execOcc.getWidth() + 10;
        }
        return 0;
    }

    public void setExecution(BasicExecutionOccurrence occ) {
        this.execOcc = occ;
        this.execOcc.addNode(this);
    }

    public BasicExecutionOccurrence getExecOcc() {
        return this.execOcc;
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(int occ) {
        this.occurrence = occ;
    }

    @Override
    public void draw(IGC context) {
        if (this.isSelected() || this.execOcc != null && this.execOcc.isSelected() || this.execOcc != null && this.execOcc.getLifeline() != null && this.execOcc.getLifeline().isSelected()) {
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_EXEC"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_EXEC"));
        }
        context.drawImage(this.image, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public String getArrayId() {
        return GLYPH;
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        return true;
    }

    @Override
    public boolean contains(int _x, int _y) {
        int height;
        int width;
        int y;
        int x = this.getX();
        return Frame.contains(x, y = this.getY(), width = this.getWidth(), height = this.getHeight(), _x, _y);
    }
}

