/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard;

import org.eclipse.linuxtools.systemtap.ui.dashboard.DashboardComposite;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.StopGraphAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardGraphData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.GraphTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class DashboardAdapter {
    public CTabFolder folder;
    public DragSource dragSource;
    public DropTarget dropTarget;
    private ToolItem close;
    private ToolItem min;
    private ToolItem max;
    private GraphComposite gc;
    private String modulename;
    Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
    private static final Image closeImage = DashboardPlugin.getImageDescriptor("icons/actions/graph/close.gif").createImage();
    private static final Image collapseImage = DashboardPlugin.getImageDescriptor("icons/actions/graph/collapse.gif").createImage();
    private static final Image expandImage = DashboardPlugin.getImageDescriptor("icons/actions/graph/expand.gif").createImage();
    private static final Image maxImage = DashboardPlugin.getImageDescriptor("icons/actions/graph/maximize.gif").createImage();
    private static final Image restoreImage = DashboardPlugin.getImageDescriptor("icons/actions/graph/restore.gif").createImage();

    public DashboardAdapter(DashboardComposite parent, GraphData gd, IDataSet ds, String moduleName) {
        this.folder = new CTabFolder(parent.deadComposite, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.deadComposite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.folder.setLayoutData((Object)this.folder);
        this.folder.setLayout((Layout)new FormLayout());
        ToolBar toolBar = new ToolBar((Composite)this.folder, 0x800800);
        this.min = new ToolItem(toolBar, 8);
        this.min.setImage(expandImage);
        this.close = new ToolItem(toolBar, 8);
        this.close.setImage(closeImage);
        this.max = new ToolItem(toolBar, 8);
        this.max.setImage(maxImage);
        toolBar.pack();
        this.folder.setTopRight((Control)toolBar);
        this.modulename = moduleName;
        this.resetDND(null, null);
        this.createGraph(gd, ds);
        this.wireButtons(parent);
    }

    private void createGraph(GraphData gd, IDataSet ds) {
        CTabItem item = new CTabItem(this.folder, 0);
        Composite c = new Composite((Composite)this.folder, 0);
        c.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        c.setLayoutData((Object)data);
        c.setLayout((Layout)new FormLayout());
        item.setControl((Control)c);
        this.folder.setSelection(item);
        this.gc = new GraphComposite(c, 0, gd, ds);
        this.gc.configure(false);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.gc.setLayoutData((Object)fd);
    }

    public void resetDND(DragSourceListener drag, DropTargetListener drop) {
        if (drag != null) {
            this.dragSource.removeDragListener(drag);
        }
        if (drop != null) {
            this.dropTarget.removeDropListener(drop);
        }
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dragSource = new DragSource((Control)this.folder, 2);
        this.dragSource.setTransfer(this.types);
        this.dropTarget = new DropTarget((Control)this.folder, 18);
        this.dropTarget.setTransfer(this.types);
    }

    private void wireButtons(DashboardComposite comp) {
        DashboardShimButtonController listener = new DashboardShimButtonController(this, comp);
        this.close.addSelectionListener((SelectionListener)listener);
        this.min.addSelectionListener((SelectionListener)listener);
        this.max.addSelectionListener((SelectionListener)listener);
    }

    public void setParent(Composite c) {
        this.folder.setParent(c);
    }

    public void setLayoutData(Object o) {
        this.folder.setLayoutData(o);
    }

    public void setVisible(boolean b) {
        this.folder.setVisible(b);
    }

    public AbstractChartBuilder getGraph() {
        return this.gc.getCanvas();
    }

    private void closeShim() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
        TreeNode root = (TreeNode)ambv.getViewer().getTree().getData();
        int i = 0;
        while (i < root.getChildCount()) {
            TreeNode node = root.getChildAt(i);
            int j = 0;
            while (j < node.getChildCount()) {
                GraphTreeNode child = (GraphTreeNode)node.getChildAt(j);
                if (this == ((DashboardGraphData)child.getData()).adapter) {
                    StopGraphAction sga = new StopGraphAction();
                    sga.run(child);
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.folder != null) {
            this.folder.dispose();
        }
        this.folder = null;
        if (this.close != null) {
            this.close.dispose();
        }
        this.close = null;
        if (this.min != null) {
            this.min.dispose();
        }
        this.min = null;
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        this.dragSource = null;
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dropTarget = null;
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView");
        ((DashboardView)ivp).getUpdater().removeUpdateListener((IUpdateListener)this.getGraph());
        if (this.gc != null && !this.gc.isDisposed()) {
            this.gc.dispose();
        }
        this.gc = null;
        this.types = null;
    }

    public String getmodulename() {
        return this.modulename;
    }

    private class DashboardShimButtonController
    implements SelectionListener {
        DashboardAdapter shim;
        DashboardComposite composite;
        boolean maximized = false;

        public DashboardShimButtonController(DashboardAdapter shim, DashboardComposite composite) {
            this.shim = shim;
            this.composite = composite;
        }

        public void widgetSelected(SelectionEvent e) {
            int i;
            Control[] children;
            Composite c;
            if (e.widget == DashboardAdapter.this.close) {
                DashboardAdapter.this.closeShim();
            }
            if (e.widget == DashboardAdapter.this.min) {
                c = (Composite)DashboardAdapter.this.folder.getSelection().getControl();
                children = c.getChildren();
                i = 0;
                while (i < children.length) {
                    if (children[i] instanceof GraphComposite) {
                        GraphComposite gc;
                        gc.configure(!(gc = (GraphComposite)children[i]).isSidebarVisible());
                        if (gc.isSidebarVisible()) {
                            DashboardAdapter.this.min.setImage(collapseImage);
                        } else {
                            DashboardAdapter.this.min.setImage(expandImage);
                        }
                    }
                    ++i;
                }
            }
            if (e.widget == DashboardAdapter.this.max) {
                c = (Composite)DashboardAdapter.this.folder.getSelection().getControl();
                children = c.getChildren();
                i = 0;
                while (i < children.length) {
                    if (children[i] instanceof GraphComposite) {
                        if (!this.maximized) {
                            this.composite.maximize(this.shim);
                            DashboardAdapter.this.max.setImage(restoreImage);
                            this.maximized = true;
                        } else {
                            this.composite.restore();
                            DashboardAdapter.this.max.setImage(maxImage);
                            this.maximized = false;
                        }
                    }
                    ++i;
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

