/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.changelog.core.Messages;
import org.eclipse.linuxtools.changelog.core.actions.ChangeLogAction;
import org.eclipse.linuxtools.changelog.core.actions.PrepareChangeLogAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PrepareChangelogKeyHandler
extends ChangeLogAction
implements IHandler,
IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection tempResult = null;
        try {
            IWorkbenchPage ref = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IWorkbenchPart part = ref.getActivePart();
            if (part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)part;
                IEditorInput input = editorPart.getEditorInput();
                IResource r = (IResource)input.getAdapter(IResource.class);
                if (r != null) {
                    tempResult = new StructuredSelection((Object)r);
                }
            } else {
                ISelection selected = ref.getSelection();
                if (selected instanceof IStructuredSelection) {
                    IResource r = null;
                    IStructuredSelection iss = (IStructuredSelection)selected;
                    Object o = ((IStructuredSelection)selected).getFirstElement();
                    if (o instanceof ISynchronizeModelElement) {
                        r = ((ISynchronizeModelElement)o).getResource();
                    } else if (o instanceof IAdaptable) {
                        r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
                    }
                    if (r != null) {
                        tempResult = iss;
                    }
                }
            }
            if (tempResult == null) {
                IViewReference[] iViewReferenceArray = ref.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference view = iViewReferenceArray[n2];
                    if (view.getId().equals("org.eclipse.team.sync.views.SynchronizeView")) {
                        IViewPart v = view.getView(false);
                        ISelection s = null;
                        ISelectionProvider sp = v.getViewSite().getSelectionProvider();
                        if (sp != null) {
                            s = sp.getSelection();
                        }
                        if (s != null && s instanceof IStructuredSelection) {
                            IStructuredSelection ss = (IStructuredSelection)s;
                            Object element = ss.getFirstElement();
                            IResource r = null;
                            if (element instanceof ISynchronizeModelElement) {
                                r = ((ISynchronizeModelElement)element).getResource();
                            } else if (element instanceof IAdaptable) {
                                r = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                            }
                            if (r != null) {
                                tempResult = ss;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            tempResult = null;
        }
        if (tempResult == null) {
            MessageDialog.openInformation((Shell)this.getActiveWorkbenchShell(), (String)Messages.getString("ChangeLog.PrepareChangeLog"), (String)Messages.getString("PrepareChangeLog.InfoNoProjectFound"));
            return null;
        }
        StructuredSelection result = tempResult;
        try {
            PrepareChangeLogAction exampleAction = new PrepareChangeLogAction((IStructuredSelection)result){
                private final /* synthetic */ IStructuredSelection val$result;
                {
                    this.val$result = iStructuredSelection;
                }

                public void run() {
                    this.setSelection(this.val$result);
                    this.doRun();
                }
            };
            exampleAction.run();
        }
        catch (Exception e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
        }
        return null;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    protected Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public void run(IAction action) {
        try {
            this.execute(null);
        }
        catch (ExecutionException e) {
            this.reportErr(Messages.getString("PrepareChangeLog.ErrExecuteFailed"), (Exception)((Object)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

