/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners;

import org.eclipse.linuxtools.internal.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ZoomListener
implements Listener {
    protected AbstractViewer fView;
    protected int fZoomFactor;
    protected int fZoomIncrement = 30;

    public ZoomListener(AbstractViewer view, int defaultZoomFactor) {
        this.fView = view;
        this.fZoomFactor = defaultZoomFactor;
    }

    public ZoomListener(AbstractViewer view) {
        this(view, 1);
    }

    public int getZoomFactor() {
        if (this.fZoomFactor < 1) {
            return 1;
        }
        return this.fZoomFactor;
    }

    public int getZoomIncrement() {
        return this.fZoomIncrement;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 37: {
                boolean scrollDown = event.count == 0 ? false : event.count <= 0;
                int zoomStep = this.fZoomIncrement;
                if (scrollDown) {
                    zoomStep = -this.fZoomIncrement;
                }
                this.fZoomFactor = Math.max(0, this.fZoomFactor + zoomStep);
                Canvas canvas = (Canvas)event.widget;
                if (this.fView != null) {
                    this.fView.clearBackground();
                    this.fView.redrawTitle();
                    this.fView.askForRedraw();
                }
                canvas.redraw();
            }
        }
    }

    public void setZoomIncrement(int zoomIncrement) {
        this.fZoomIncrement = zoomIncrement;
    }
}

