/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.linuxtools.dataviewers.charts.ChartConstants;
import org.eclipse.linuxtools.dataviewers.charts.view.ChartView;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.swtchart.Chart;

public class SaveChartAction
extends Action {
    private FileDialog dialog;
    private Shell shell;
    private Chart cm;

    public SaveChartAction(Shell shell, ChartView cview) {
        super("Save chart as...", Activator.getImageDescriptor("icons/save_chart.gif"));
        this.setEnabled(false);
        this.shell = shell;
        this.dialog = new FileDialog(shell, 8192);
        this.dialog.setFileName(".");
        this.dialog.setFilterPath(".");
        this.dialog.setFilterExtensions(ChartConstants.saveAsImageExt);
        this.dialog.setFilterNames(ChartConstants.saveAsImageExtNames);
        this.dialog.setText("Select an image file (extension will be set to \".jpeg\" if not recognized).");
        this.restoreState();
    }

    public void setChart(Chart chart) {
        try {
            if (chart != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.cm = chart;
        }
        catch (Throwable _) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, "Error when creating \"save as image\" action...", _);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public void run() {
        String path = this.dialog.open();
        if (path == null) {
            return;
        }
        final File file = new File(path);
        if (file.exists()) {
            boolean overwrite = MessageDialog.openQuestion((Shell)this.shell, (String)"Confirm overwrite", (String)"File already exists. Overwrite?");
            if (overwrite) {
                file.delete();
            } else {
                return;
            }
        }
        final String ext = this.dialog.getFilterNames()[this.dialog.getFilterIndex()];
        UIJob saveAsImage = new UIJob("Save chart as " + file.getName()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                int extention = ext.contains("PNG") ? 5 : (ext.contains("JPG") || ext.contains("JPEG") ? 4 : 5);
                try {
                    monitor.beginTask("Saving chart as " + file.getName() + "...", -1);
                    file.createNewFile();
                    SaveChartAction.this.generateImageFile(file, extention);
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.linuxtools.dataviewers.charts", "Error saving chart to \"" + file.getAbsolutePath() + "\":" + e.getMessage(), (Throwable)e);
                }
            }
        };
        saveAsImage.setUser(true);
        saveAsImage.schedule();
        this.saveState();
    }

    public void restoreState() {
        try {
            IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("charts_saveasimg_section");
            if (settings == null) {
                settings = Activator.getDefault().getDialogSettings().addNewSection("charts_saveasimg_section");
                return;
            }
            this.dialog.setFileName(settings.get("IMG_FILE_NAME"));
            this.dialog.setFilterPath(settings.get("IMG_FILTER_PATH"));
        }
        catch (Exception e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public void saveState() {
        try {
            IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("charts_saveasimg_section");
            if (settings == null) {
                settings = Activator.getDefault().getDialogSettings().addNewSection("charts_saveasimg_section");
            }
            settings.put("IMG_FILE_NAME", this.dialog.getFileName());
            settings.put("IMG_FILTER_PATH", this.dialog.getFilterPath());
        }
        catch (Exception e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    protected void generateImageFile(File file, int extention) {
        Display dsp = Display.getCurrent();
        GC gc = new GC((Drawable)this.cm);
        Image img = new Image((Device)dsp, this.cm.getSize().x, this.cm.getSize().y);
        gc.copyArea(img, 0, 0);
        gc.dispose();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{img.getImageData()};
        imageLoader.save(file.getAbsolutePath(), extention);
    }
}

