/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenTraceHandler
extends AbstractHandler {
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";
    private TmfTraceElement fTrace = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fTrace = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfTraceElement) {
            this.fTrace = (TmfTraceElement)element;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (this.fTrace == null) {
            return null;
        }
        this.fTrace = this.fTrace.getElementUnderTraceFolder();
        ITmfTrace<?> trace = this.fTrace.instantiateTrace();
        ITmfEvent traceEvent = this.fTrace.instantiateEvent();
        if (trace == null || traceEvent == null) {
            this.displayErrorMsg(Messages.OpenTraceHandler_NoTraceType);
            return null;
        }
        String editorId = this.fTrace.getEditorId();
        boolean usesEditor = editorId != null && editorId.length() > 0;
        try {
            trace.initTrace(this.fTrace.getResource(), this.fTrace.getLocation().getPath(), traceEvent.getClass());
        }
        catch (TmfTraceException e) {
            this.displayErrorMsg(String.valueOf(Messages.OpenTraceHandler_NoTrace) + "\n\n" + (Object)((Object)e));
            return null;
        }
        IResource resource = this.fTrace.getResource();
        IFile file = null;
        if (resource instanceof IFile) {
            file = (IFile)resource;
        } else if (resource instanceof IFolder) {
            try {
                IFile bookmarksFile = this.fTrace.getProject().getTracesFolder().getResource().getFile(BOOKMARKS_HIDDEN_FILE);
                if (!bookmarksFile.exists()) {
                    ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                    bookmarksFile.create((InputStream)source, true, null);
                }
                bookmarksFile.setHidden(true);
                IFolder folder = (IFolder)resource;
                file = folder.getFile(String.valueOf(this.fTrace.getName()) + '_');
                if (!file.exists()) {
                    file.createLink(bookmarksFile.getLocation(), 256, null);
                }
                file.setHidden(true);
                if (usesEditor) {
                    file.setPersistentProperty(TmfCommonConstants.TRACETYPE, this.fTrace.getTraceType());
                } else {
                    file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfTrace.class.getCanonicalName());
                }
            }
            catch (CoreException e) {
                TmfUiPlugin.getDefault().logError("Error opening trace " + this.fTrace.getName(), e);
            }
        }
        if (usesEditor) {
            try {
                TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.findEditor((IEditorInput)new FileEditorInput(file));
                if (editor != null && editor instanceof IReusableEditor) {
                    activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                    activePage.activate((IWorkbenchPart)editor);
                } else {
                    activePage.openEditor((IEditorInput)editorInput, editorId);
                    if (resource instanceof IFile) {
                        IDE.setDefaultEditor((IFile)((IFile)resource), (String)editorId);
                    }
                }
            }
            catch (PartInitException e) {
                TmfUiPlugin.getDefault().logError("Error opening trace " + this.fTrace.getName(), e);
            }
        } else {
            ITmfTrace[] traces = new ITmfTrace[]{trace};
            TmfExperiment experiment = new TmfExperiment(traceEvent.getClass(), this.fTrace.getName(), traces, trace.getCacheSize());
            experiment.setBookmarksFile(file);
            TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
            IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.linuxtools.tmf.ui.editors.eventsView");
        }
        return null;
    }

    private void displayErrorMsg(String errorMsg) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(Messages.OpenTraceHandler_Title);
        mb.setMessage(errorMsg);
        mb.open();
    }
}

