/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.request;

import java.util.Vector;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;

public class TmfCoalescedDataRequest<T extends ITmfEvent>
extends TmfDataRequest<T> {
    protected Vector<ITmfDataRequest<T>> fRequests = new Vector();

    public TmfCoalescedDataRequest(Class<T> dataType) {
        this(dataType, 0L, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, ITmfDataRequest.ExecutionType priority) {
        this(dataType, 0L, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, long index) {
        this(dataType, index, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, long index, ITmfDataRequest.ExecutionType priority) {
        this(dataType, index, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, long index, int nbRequested) {
        this(dataType, index, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, long index, int nbRequested, ITmfDataRequest.ExecutionType priority) {
        this(dataType, index, nbRequested, 1000, priority);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, long index, int nbRequested, int blockSize) {
        super(dataType, index, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedDataRequest(Class<T> dataType, long index, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        super(dataType, index, nbRequested, blockSize, priority);
    }

    public void addRequest(ITmfDataRequest<T> request) {
        this.fRequests.add(request);
    }

    public boolean isCompatible(ITmfDataRequest<T> request) {
        boolean ok = request.getIndex() == this.getIndex();
        ok &= request.getNbRequested() == this.getNbRequested();
        return ok &= request.getExecType() == this.getExecType();
    }

    public String getSubRequestIds() {
        StringBuffer result = new StringBuffer("[");
        int i = 0;
        while (i < this.fRequests.size()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.fRequests.get(i).getRequestId());
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public void handleData(T data) {
        super.handleData(data);
        if (this.getClass() == TmfCoalescedDataRequest.class) {
            for (ITmfDataRequest<T> request : this.fRequests) {
                if (request.isCompleted() || !request.getDataType().isInstance(data)) continue;
                request.handleData(data);
            }
        }
    }

    @Override
    public void start() {
        for (ITmfDataRequest<T> request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.start();
        }
        super.start();
    }

    @Override
    public void done() {
        for (ITmfDataRequest<T> request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.done();
        }
        super.done();
    }

    @Override
    public void fail() {
        for (ITmfDataRequest<T> request : this.fRequests) {
            request.fail();
        }
        super.fail();
    }

    @Override
    public void cancel() {
        for (ITmfDataRequest<T> request : this.fRequests) {
            if (request.isCompleted()) continue;
            request.cancel();
        }
        super.cancel();
    }

    @Override
    public boolean isCompleted() {
        if (super.isCompleted()) {
            return true;
        }
        if (this.fRequests.size() > 0) {
            for (ITmfDataRequest<T> request : this.fRequests) {
                if (request.isCompleted()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (super.isCancelled()) {
            return true;
        }
        if (this.fRequests.size() > 0) {
            for (ITmfDataRequest<T> request : this.fRequests) {
                if (request.isCancelled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfCoalescedDataRequest) {
            TmfCoalescedDataRequest request = (TmfCoalescedDataRequest)other;
            return request.getDataType() == this.getDataType() && request.getIndex() == this.getIndex() && request.getNbRequested() == this.getNbRequested() && request.getExecType() == this.getExecType();
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfCoalescedDataRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + this.getIndex() + "," + this.getNbRequested() + "," + this.getBlockSize() + ")]";
    }
}

