/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentContext;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentLocation;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;

public class TmfLegacyExperiment<T extends ITmfEvent>
extends TmfExperiment<T> {
    protected ITmfTimestamp fEpoch;
    protected Vector<TmfCheckpoint> fCheckpoints;
    protected TmfExperimentContext fExperimentContext;
    private IResource fResource;
    private static final int DEFAULT_INDEX_PAGE_SIZE = 5000;
    protected TmfTimeRange fIndexingPendingRange = TmfTimeRange.NULL_RANGE;
    private boolean fIndexing = false;

    public TmfLegacyExperiment<T> clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean validate(IProject project, String path) {
        return true;
    }

    public TmfLegacyExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, ITmfTimestamp epoch, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.ZERO, indexPageSize, false);
    }

    public TmfLegacyExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, ITmfTimestamp epoch, int indexPageSize, boolean preIndexExperiment) {
        super(type, id, traces, indexPageSize);
        this.setTimeRange(TmfTimeRange.NULL_RANGE);
        this.fEpoch = epoch;
        this.fCheckpoints = new Vector();
        if (preIndexExperiment) {
            this.indexExperiment(true, 0, TmfTimeRange.ETERNITY);
        }
    }

    public TmfLegacyExperiment(Class<T> type, String id, ITmfTrace<T>[] traces) {
        this(type, id, traces, TmfTimestamp.ZERO, 5000);
    }

    public TmfLegacyExperiment(Class<T> type, String id, ITmfTrace<T>[] traces, int indexPageSize, boolean preIndexExperiment) {
        this(type, id, traces, TmfTimestamp.ZERO, indexPageSize);
        if (preIndexExperiment) {
            this.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, true);
        }
    }

    @Override
    public synchronized void dispose() {
        TmfExperimentDisposedSignal signal = new TmfExperimentDisposedSignal((Object)this, this);
        this.broadcast(signal);
        if (fCurrentExperiment == this) {
            fCurrentExperiment = null;
        }
        if (this.fTraces != null) {
            ITmfTrace[] iTmfTraceArray = this.fTraces;
            int n = this.fTraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace trace = iTmfTraceArray[n2];
                trace.dispose();
                ++n2;
            }
            this.fTraces = null;
        }
        if (this.fCheckpoints != null) {
            this.fCheckpoints.clear();
        }
        super.dispose();
    }

    public ITmfTimestamp getEpoch() {
        return this.fEpoch;
    }

    @Override
    public ITmfTrace<T>[] getTraces() {
        return this.fTraces;
    }

    @Override
    public ITmfTimestamp getTimestamp(int index) {
        TmfExperimentContext context = this.seekEvent(index);
        T event = this.getNext(context);
        return event != null ? event.getTimestamp() : null;
    }

    protected void updateTimeRange() {
        ITmfTimestamp startTime = this.getStartTime();
        ITmfTimestamp endTime = this.getEndTime();
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTimestamp traceEndTime;
            ITmfTrace trace = iTmfTraceArray[n2];
            ITmfTimestamp traceStartTime = trace.getStartTime();
            if (traceStartTime.compareTo(startTime, true) < 0) {
                startTime = traceStartTime;
            }
            if ((traceEndTime = trace.getEndTime()).compareTo(endTime, true) > 0) {
                endTime = traceEndTime;
            }
            ++n2;
        }
        this.setTimeRange(new TmfTimeRange(startTime, endTime));
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<T> request) {
        ITmfTimestamp timestamp;
        ITmfTimestamp iTmfTimestamp = timestamp = request instanceof ITmfEventRequest ? ((ITmfEventRequest)request).getRange().getStartTime() : null;
        if (TmfTimestamp.BIG_BANG.equals(timestamp) || request.getIndex() > 0L) {
            timestamp = null;
        }
        TmfExperimentContext context = null;
        if (timestamp != null) {
            context = this.seekEvent(timestamp);
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
        } else {
            context = this.fExperimentContext != null && this.fExperimentContext.getRank() == request.getIndex() ? this.fExperimentContext : this.seekEvent(request.getIndex());
        }
        return context;
    }

    @Override
    public synchronized TmfExperimentContext seekEvent(ITmfLocation<?> location) {
        if (location != null && !(location instanceof TmfExperimentLocation)) {
            return null;
        }
        if (this.fTraces == null) {
            return null;
        }
        TmfExperimentLocation expLocation = location == null ? new TmfExperimentLocation(new TmfLocationArray(new ITmfLocation[this.fTraces.length])) : (TmfExperimentLocation)location.clone();
        TmfExperimentContext context = new TmfExperimentContext(new ITmfContext[this.fTraces.length]);
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfLocation<? extends Comparable<?>> traceLocation = ((TmfLocationArray)expLocation.getLocation()).getLocations()[i];
            context.getContexts()[i] = this.fTraces[i].seekEvent(traceLocation);
            ((TmfLocationArray)expLocation.getLocation()).getLocations()[i] = context.getContexts()[i].getLocation().clone();
            context.getEvents()[i] = this.fTraces[i].getNext(context.getContexts()[i]);
            ++i;
        }
        context.setLocation(expLocation);
        context.setLastTrace(-1);
        context.setRank(-1L);
        this.fExperimentContext = context;
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TmfExperimentContext seekEvent(ITmfTimestamp timestamp) {
        ITmfLocation<?> location;
        int index;
        if (timestamp == null) {
            timestamp = TmfTimestamp.BIG_BANG;
        }
        if ((index = Collections.binarySearch(this.fCheckpoints, new TmfCheckpoint(timestamp, null))) < 0) {
            index = Math.max(0, -(index + 2));
        }
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() > 0) {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            } else {
                location = null;
            }
        }
        ITmfContext context = this.seekEvent((ITmfLocation)location);
        ((TmfContext)context).setRank((long)index * (long)this.getCacheSize());
        T event = this.parseEvent(context);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            this.getNext(context);
            event = this.parseEvent(context);
        }
        if (event == null) {
            ((TmfContext)context).setLocation(null);
            ((TmfContext)context).setRank(-1L);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TmfExperimentContext seekEvent(long rank) {
        ITmfLocation<?> location;
        int fIndexPageSize = this.getCacheSize();
        int index = (int)rank / fIndexPageSize;
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() == 0) {
                location = null;
            } else {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            }
        }
        ITmfContext context = this.seekEvent((ITmfLocation)location);
        ((TmfContext)context).setRank((long)index * (long)fIndexPageSize);
        T event = this.parseEvent(context);
        long pos = ((TmfContext)context).getRank();
        while (event != null && pos++ < rank) {
            this.getNext(context);
            event = this.parseEvent(context);
        }
        if (event == null) {
            ((TmfContext)context).setLocation(null);
            ((TmfContext)context).setRank(-1L);
        }
        return context;
    }

    @Override
    public TmfContext seekEvent(double ratio) {
        TmfExperimentContext context = this.seekEvent((long)(ratio * (double)this.getNbEvents()));
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        if (location instanceof TmfExperimentLocation) {
            return (double)((TmfContext)this.seekEvent((ITmfLocation)location)).getRank() / (double)this.getNbEvents();
        }
        return 0.0;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        if (this.fExperimentContext != null) {
            return this.fExperimentContext.getLocation();
        }
        return null;
    }

    @Override
    public synchronized T getNext(ITmfContext context) {
        ITmfEvent[] eventArray;
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.fExperimentContext = this.seekEvent((ITmfLocation)context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            ITmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = this.fTraces[lastTrace].getNext(traceContext);
            expContext.setLastTrace(-1);
        }
        if ((eventArray = expContext.getEvents()) == null) {
            return null;
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        if (eventArray.length == 1) {
            if (eventArray[0] != null) {
                timestamp = eventArray[0].getTimestamp();
                trace = 0;
            }
        } else {
            int i = 0;
            while (i < eventArray.length) {
                ITmfTimestamp otherTS;
                ITmfEvent event = eventArray[i];
                if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                    trace = i;
                    timestamp = otherTS;
                }
                ++i;
            }
        }
        ITmfEvent event = null;
        if (trace != -1) {
            this.updateIndex(expContext, timestamp);
            ITmfContext traceContext = expContext.getContexts()[trace];
            TmfExperimentLocation expLocation = (TmfExperimentLocation)expContext.getLocation();
            ((TmfLocationArray)expLocation.getLocation()).getLocations()[trace] = traceContext.getLocation().clone();
            expContext.setLastTrace(trace);
            expContext.increaseRank();
            event = expContext.getEvents()[trace];
            this.fExperimentContext = expContext;
        }
        return (T)event;
    }

    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        long rank = context.getRank();
        if (context.hasValidRank() && rank % (long)this.getCacheSize() == 0L) {
            long position = rank / (long)this.getCacheSize();
            if ((long)this.fCheckpoints.size() == position) {
                ITmfLocation<? extends Comparable<?>> location = context.getLocation().clone();
                this.fCheckpoints.add(new TmfCheckpoint(timestamp.clone(), location));
            }
        }
    }

    @Override
    public T parseEvent(ITmfContext context) {
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.seekEvent((ITmfLocation)context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            ITmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = this.fTraces[lastTrace].getNext(traceContext);
            expContext.setLastTrace(-1);
            this.fExperimentContext = (TmfExperimentContext)context;
        }
        int trace = -1;
        ITmfTimestamp timestamp = TmfTimestamp.BIG_CRUNCH;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfTimestamp otherTS;
            ITmfEvent event = expContext.getEvents()[i];
            if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                trace = i;
                timestamp = otherTS;
            }
            ++i;
        }
        ITmfEvent event = null;
        if (trace != -1) {
            event = expContext.getEvents()[trace];
        }
        return (T)event;
    }

    @Override
    public String toString() {
        return "[TmfExperiment (" + this.getName() + ")]";
    }

    @Override
    public long getStreamingInterval() {
        long interval = 0L;
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            interval = Math.max(interval, trace.getStreamingInterval());
            ++n2;
        }
        return interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexExperiment(boolean waitForCompletion, int index, TmfTimeRange timeRange) {
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fIndexing) {
                return;
            }
            this.fIndexing = true;
        }
        final Job job = new Job("Indexing " + this.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        TmfEventRequest<ITmfEvent> request = new TmfEventRequest<ITmfEvent>(ITmfEvent.class, timeRange, (long)index, Integer.MAX_VALUE, this.getCacheSize(), ITmfDataRequest.ExecutionType.BACKGROUND){
            ITmfTimestamp startTime;
            ITmfTimestamp lastTime;
            long initialNbEvents;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.startTime = TmfLegacyExperiment.this.getTimeRange().equals(TmfTimeRange.NULL_RANGE) ? null : TmfLegacyExperiment.this.getStartTime();
                this.lastTime = TmfLegacyExperiment.this.getTimeRange().equals(TmfTimeRange.NULL_RANGE) ? null : TmfLegacyExperiment.this.getEndTime();
                this.initialNbEvents = TmfLegacyExperiment.this.getNbEvents();
            }

            @Override
            public void handleStarted() {
                super.handleStarted();
            }

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    ITmfTimestamp ts = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = ts.clone();
                    }
                    this.lastTime = ts.clone();
                }
                if (this.getNbRead() % TmfLegacyExperiment.this.getCacheSize() == 1 && this.getNbRead() != 1) {
                    this.updateExperiment();
                }
            }

            @Override
            public void handleSuccess() {
                if (this.getRange().getEndTime() != TmfTimestamp.BIG_CRUNCH) {
                    this.lastTime = this.getRange().getEndTime();
                }
                this.updateExperiment();
                super.handleSuccess();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
                Vector<TmfCheckpoint> vector = TmfLegacyExperiment.this.fCheckpoints;
                synchronized (vector) {
                    TmfLegacyExperiment.this.fIndexing = false;
                    if (!TmfLegacyExperiment.this.fIndexingPendingRange.equals(TmfTimeRange.NULL_RANGE)) {
                        TmfLegacyExperiment.this.indexExperiment(false, (int)TmfLegacyExperiment.this.getNbEvents(), TmfLegacyExperiment.this.fIndexingPendingRange);
                        TmfLegacyExperiment.this.fIndexingPendingRange = TmfTimeRange.NULL_RANGE;
                    }
                }
            }

            private void updateExperiment() {
                int nbRead = this.getNbRead();
                if (this.startTime != null) {
                    TmfLegacyExperiment.this.setTimeRange(new TmfTimeRange(this.startTime, this.lastTime.clone()));
                }
                if (nbRead != 0) {
                    TmfLegacyExperiment.this.setNbEvents(this.initialNbEvents + (long)nbRead);
                    TmfLegacyExperiment.this.notifyListeners();
                }
            }
        };
        this.sendRequest(request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyListeners() {
        this.broadcast(new TmfExperimentUpdatedSignal((Object)this, this));
    }

    @Override
    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        if (signal.getExperiment() == this) {
            this.indexExperiment(false, (int)this.getNbEvents(), signal.getRange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace == signal.getTrace()) {
                Vector<TmfCheckpoint> vector = this.fCheckpoints;
                synchronized (vector) {
                    if (this.fIndexing) {
                        if (this.fIndexingPendingRange.equals(TmfTimeRange.NULL_RANGE)) {
                            this.fIndexingPendingRange = signal.getRange();
                        } else {
                            ITmfTimestamp startTime = this.fIndexingPendingRange.getStartTime();
                            ITmfTimestamp endTime = this.fIndexingPendingRange.getEndTime();
                            if (signal.getRange().getStartTime().compareTo(startTime) < 0) {
                                startTime = signal.getRange().getStartTime();
                            }
                            if (signal.getRange().getEndTime().compareTo(endTime) > 0) {
                                endTime = signal.getRange().getEndTime();
                            }
                            this.fIndexingPendingRange = new TmfTimeRange(startTime, endTime);
                        }
                        return;
                    }
                }
                this.indexExperiment(false, (int)this.getNbEvents(), signal.getRange());
                return;
            }
            ++n2;
        }
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }
}

