/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.resources.model;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.TimeRangeEventResource;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.model.ResourceKey;

public class ResourceContainer
implements ItemContainer<TimeRangeEventResource> {
    private final HashMap<ResourceKey, TimeRangeEventResource> resources = new HashMap();
    private static Integer uniqueId = 0;

    @Override
    public void addItem(TimeRangeEventResource newItem) {
        if (newItem != null) {
            this.resources.put(new ResourceKey(newItem), newItem);
        }
    }

    @Override
    public Integer getUniqueId() {
        Integer n = uniqueId;
        uniqueId = n + 1;
        return n;
    }

    public TimeRangeEventResource[] readItems() {
        return this.resources.values().toArray(new TimeRangeEventResource[this.resources.size()]);
    }

    @Override
    public void clearChildren() {
        TimeRangeEventResource newRes = null;
        Iterator<ResourceKey> iterator = this.resources.keySet().iterator();
        while (iterator.hasNext()) {
            newRes = this.resources.get(iterator.next());
            newRes.reset();
        }
    }

    @Override
    public void clearItems() {
        this.resources.clear();
    }

    @Override
    public void removeItems(String traceId) {
        ResourceKey newKey2 = null;
        for (ResourceKey newKey2 : this.resources.keySet()) {
            if (!this.resources.get(newKey2).getTraceId().equals(traceId)) continue;
            this.resources.remove(newKey2);
        }
    }

    public TimeRangeEventResource findItem(Long searchedId, TimeRangeEventResource.ResourceTypes searchedType, String searchedTraceId) {
        TimeRangeEventResource foundResource = this.resources.get(new ResourceKey(searchedId, searchedTraceId, searchedType));
        return foundResource;
    }
}

