/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph;

import java.util.Map;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class TimeGraphProvider
implements ITimeGraphProvider {
    protected TimeGraphControl fTimeGraphControl;

    @Override
    public void setTimeGraphControl(TimeGraphControl timeGraphControl) {
        this.fTimeGraphControl = timeGraphControl;
    }

    @Override
    public void drawItems(Rectangle bounds, ITimeDataProvider timeProvider, TimeGraphItem[] items, int topIndex, int nameSpace, GC gc) {
        this.fTimeGraphControl.drawItems(bounds, timeProvider, items, topIndex, nameSpace, gc);
    }

    @Override
    public void drawItem(TimeGraphItem item, Rectangle bounds, ITimeDataProvider timeProvider, int i, int nameSpace, GC gc) {
        this.fTimeGraphControl.drawItem(item, bounds, timeProvider, i, nameSpace, gc);
    }

    @Override
    public void drawState(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        int colorIdx = this.getEventColorVal(event);
        this.drawState(colors, colorIdx, rect, gc, selected, rectBound, timeSelected);
    }

    @Override
    public void drawState(TimeGraphColorScheme colors, int colorIdx, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        this.fTimeGraphControl.drawState(colors, colorIdx, rect, gc, selected, rectBound, timeSelected);
    }

    @Override
    public int getEventColorVal(ITimeEvent event) {
        StateColor colors = this.getEventColor(event);
        if (colors == StateColor.GREEN) {
            return 1;
        }
        if (colors == StateColor.DARK_BLUE) {
            return 2;
        }
        if (colors == StateColor.RED) {
            return 5;
        }
        if (colors == StateColor.GOLD) {
            return 4;
        }
        if (colors == StateColor.ORANGE) {
            return 3;
        }
        if (colors == StateColor.GRAY) {
            return 6;
        }
        if (colors == StateColor.DARK_GREEN) {
            return 7;
        }
        if (colors == StateColor.DARK_YELLOW) {
            return 8;
        }
        if (colors == StateColor.MAGENTA3) {
            return 9;
        }
        if (colors == StateColor.PURPLE1) {
            return 10;
        }
        if (colors == StateColor.PINK1) {
            return 11;
        }
        if (colors == StateColor.AQUAMARINE) {
            return 12;
        }
        if (colors == StateColor.LIGHT_BLUE) {
            return 13;
        }
        if (colors == StateColor.CADET_BLUE) {
            return 30;
        }
        if (colors == StateColor.OLIVE) {
            return 15;
        }
        return 0;
    }

    @Override
    public abstract StateColor getEventColor(ITimeEvent var1);

    @Override
    public abstract String getTraceClassName(ITimeGraphEntry var1);

    @Override
    public String getEventName(ITimeEvent event) {
        return this.getEventName(event, true, false);
    }

    @Override
    public abstract String getEventName(ITimeEvent var1, boolean var2, boolean var3);

    @Override
    public String composeTraceName(ITimeGraphEntry trace, boolean inclState) {
        String name = trace.getName();
        String threadClass = this.getTraceClassName(trace);
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        return name;
    }

    @Override
    public String composeEventName(ITimeEvent event) {
        String name = event.getEntry().getName();
        String threadClass = this.getTraceClassName(event.getEntry());
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        name = String.valueOf(name) + " (" + this.getEventName(event, false, true) + ")";
        return name;
    }

    @Override
    public abstract Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1);

    @Override
    public Image getItemImage(Object obj) {
        return null;
    }

    @Override
    public abstract String getStateName(StateColor var1);

    public static enum StateColor {
        GREEN,
        DARK_BLUE,
        RED,
        GOLD,
        ORANGE,
        GRAY,
        BLACK,
        DARK_GREEN,
        DARK_YELLOW,
        MAGENTA3,
        PURPLE1,
        PINK1,
        AQUAMARINE,
        LIGHT_BLUE,
        CADET_BLUE,
        OLIVE;

        private String stateName;

        private StateColor() {
            String undef;
            this.stateName = undef = "Undefined";
        }

        public String getStateName() {
            return this.stateName;
        }

        public void setStateName(String stateName) {
            this.stateName = stateName;
        }
    }
}

