/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DiagramToolTip {
    protected Control fParent = null;
    protected Shell fToolTipShell = null;
    protected String fText = null;
    protected Text fTextBox = null;

    public DiagramToolTip(Control parent) {
        this.fParent = parent;
        this.fToolTipShell = new Shell(this.fParent.getShell(), 2);
        this.fToolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.fTextBox = new Text((Composite)this.fToolTipShell, 66);
        this.fTextBox.setBackground(Display.getDefault().getSystemColor(29));
    }

    public void showToolTip(String value) {
        if (value == null || value.equalsIgnoreCase("")) {
            this.fToolTipShell.setVisible(false);
            return;
        }
        this.fText = value;
        int w = this.fToolTipShell.getBounds().width;
        Point hr = Display.getDefault().getCursorLocation();
        int cursorH = 32;
        int i = 0;
        while (i < Display.getDefault().getCursorSizes().length) {
            if (Display.getDefault().getCursorSizes()[i].y < cursorH) {
                cursorH = Display.getDefault().getCursorSizes()[i].y;
            }
            ++i;
        }
        if (hr.x + w > Display.getDefault().getBounds().width) {
            int tempX = hr.x + w - Display.getDefault().getBounds().width;
            if (tempX > Display.getDefault().getBounds().width) {
                hr.x = 0;
            }
            hr.x -= tempX;
        }
        this.fTextBox.setText(value);
        int charactersPerColumn = 100;
        GC gc = new GC((Drawable)this.fTextBox);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int width = charactersPerColumn * fm.getAverageCharWidth();
        this.fTextBox.setSize(this.fTextBox.computeSize(width, this.fTextBox.getLineCount() * this.fTextBox.getLineHeight()));
        this.fToolTipShell.setLocation(hr.x, hr.y + cursorH);
        this.fToolTipShell.setSize(this.fTextBox.getSize());
        this.fTextBox.setVisible(true);
        this.fToolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.fToolTipShell.setVisible(false);
    }
}

