/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpointIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public abstract class TmfTrace<T extends ITmfEvent>
extends TmfEventProvider<T>
implements ITmfTrace<T> {
    public static final int DEFAULT_TRACE_CACHE_SIZE = 10000;
    private IResource fResource;
    private String fPath;
    protected int fCacheSize = 10000;
    protected long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    protected long fStreamingInterval = 0L;
    protected ITmfTraceIndexer<ITmfTrace<ITmfEvent>> fIndexer;
    protected ITmfEventParser<T> fParser;

    public TmfTrace() {
        this.fIndexer = new TmfCheckpointIndexer<ITmfTrace<ITmfEvent>>(this);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize) throws TmfTraceException {
        this(resource, type, path, cacheSize, 0L, null);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize, long interval) throws TmfTraceException {
        this(resource, type, path, cacheSize, interval, null);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize, long interval, ITmfTraceIndexer<?> indexer) throws TmfTraceException {
        this(resource, type, path, cacheSize, interval, null, null);
    }

    protected TmfTrace(IResource resource, Class<T> type, String path, int cacheSize, long interval, ITmfTraceIndexer<?> indexer, ITmfEventParser<T> parser) throws TmfTraceException {
        this.fCacheSize = cacheSize > 0 ? cacheSize : 10000;
        this.fStreamingInterval = interval;
        this.fIndexer = indexer != null ? indexer : new TmfCheckpointIndexer(this, this.fCacheSize);
        this.fParser = parser;
        this.initialize(resource, path, type);
    }

    public TmfTrace(TmfTrace<T> trace) throws TmfTraceException {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        this.fCacheSize = trace.getCacheSize();
        this.fStreamingInterval = trace.getStreamingInterval();
        this.fIndexer = new TmfCheckpointIndexer<ITmfTrace<ITmfEvent>>(this);
        this.fParser = trace.fParser;
        this.initialize(trace.getResource(), trace.getPath(), trace.getEventType());
    }

    @Override
    public void initTrace(IResource resource, String path, Class<T> type) throws TmfTraceException {
        this.initialize(resource, path, type);
        this.fIndexer.buildIndex(false);
    }

    protected void initialize(IResource resource, String path, Class<T> type) throws TmfTraceException {
        String traceName;
        if (path == null) {
            throw new TmfTraceException("Invalid trace path");
        }
        this.fPath = path;
        this.fResource = resource;
        String string = traceName = resource != null ? resource.getName() : null;
        if (traceName == null) {
            int sep = path.lastIndexOf(47);
            String string2 = traceName = sep >= 0 ? path.substring(sep + 1) : path;
        }
        if (this.fParser == null) {
            if (this instanceof ITmfEventParser) {
                this.fParser = (ITmfEventParser)((Object)this);
            } else {
                throw new TmfTraceException("Invalid trace parser");
            }
        }
        super.init(traceName, type);
    }

    protected boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    @Override
    public Class<T> getEventType() {
        return super.getType();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public int getCacheSize() {
        return this.fCacheSize;
    }

    @Override
    public long getStreamingInterval() {
        return this.fStreamingInterval;
    }

    @Override
    public synchronized long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime.clone();
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime.clone();
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime().clone();
        this.fEndTime = range.getEndTime().clone();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime.clone();
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime.clone();
    }

    protected void setStreamingInterval(long interval) {
        this.fStreamingInterval = interval > 0L ? interval : 0L;
    }

    @Override
    public synchronized ITmfContext seekEvent(long rank) {
        if (rank <= 0L) {
            ITmfContext context = this.seekEvent((ITmfLocation<?>)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(rank);
        long pos = context.getRank();
        if (pos < rank) {
            ITmfEvent event = this.readNextEvent(context);
            while (event != null && ++pos < rank) {
                event = this.readNextEvent(context);
            }
        }
        return context;
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            ITmfContext context = this.seekEvent((ITmfLocation<?>)null);
            context.setRank(0L);
            return context;
        }
        ITmfContext context = this.fIndexer.seekIndex(timestamp);
        ITmfContext nextEventContext = context.clone();
        ITmfEvent event = this.readNextEvent(nextEventContext);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            context.setLocation(nextEventContext.getLocation().clone());
            context.increaseRank();
            event = this.readNextEvent(nextEventContext);
        }
        return context;
    }

    @Override
    public synchronized ITmfEvent readNextEvent(ITmfContext context) {
        T event = this.fParser.parseEvent(context);
        if (event != null) {
            this.updateAttributes(context, event.getTimestamp());
            context.setLocation(this.getCurrentLocation());
            context.increaseRank();
            this.processEvent((ITmfEvent)event);
        }
        return event;
    }

    protected void processEvent(ITmfEvent event) {
    }

    protected synchronized void updateAttributes(ITmfContext context, ITmfTimestamp timestamp) {
        if (this.fStartTime.compareTo(timestamp, false) > 0) {
            this.fStartTime = timestamp;
        }
        if (this.fEndTime.compareTo(timestamp, false) < 0) {
            this.fEndTime = timestamp;
        }
        if (context.hasValidRank()) {
            long rank = context.getRank();
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            this.fIndexer.updateIndex(context, timestamp);
        }
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public T getNext(ITmfContext context) {
        if (context instanceof TmfContext) {
            return (T)this.readNextEvent(context);
        }
        return null;
    }

    public synchronized String toString() {
        return "TmfTrace [fPath=" + this.fPath + ", fCacheSize=" + this.fCacheSize + ", fNbEvents=" + this.fNbEvents + ", fStartTime=" + this.fStartTime + ", fEndTime=" + this.fEndTime + ", fStreamingInterval=" + this.fStreamingInterval + "]";
    }
}

