/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfContent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventType;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;

public final class CtfTmfEvent
implements ITmfEvent {
    private static final String NO_STREAM = "No stream";
    private static final String EMPTY_CTF_EVENT_NAME = "Empty CTF event";
    private static final String CONTEXT_ID = "Ctf Event";
    private final CtfTmfTrace fTrace;
    private final long timestamp;
    private final int sourceCPU;
    private final long typeId;
    private final String eventName;
    private final String fileName;
    private final CtfTmfContent fContent;
    private static CtfTmfEvent nullEvent = null;
    private ITmfTimestamp fTimestamp = null;
    String fSource = null;
    private CtfTmfEventType type = null;
    String fReference = null;

    public CtfTmfEvent(EventDefinition eventDef, String fileName, CtfTmfTrace originTrace) {
        this.fTrace = originTrace;
        if (eventDef == null) {
            this.timestamp = -1L;
            this.sourceCPU = -1;
            this.typeId = -1L;
            this.fileName = NO_STREAM;
            this.eventName = EMPTY_CTF_EVENT_NAME;
            this.fContent = null;
            return;
        }
        Long offset = originTrace.getCTFTrace().getOffset();
        this.timestamp = eventDef.timestamp + offset;
        this.sourceCPU = eventDef.getCPU();
        this.typeId = eventDef.getDeclaration().getId();
        this.eventName = eventDef.getDeclaration().getName();
        this.fileName = fileName;
        this.fContent = new CtfTmfContent(":root:", CtfTmfEvent.parseFields(eventDef));
    }

    private static CtfTmfEventField[] parseFields(EventDefinition eventDef) {
        ArrayList<CtfTmfEventField> fields = new ArrayList<CtfTmfEventField>();
        StructDefinition structFields = eventDef.getFields();
        HashMap definitions = structFields.getDefinitions();
        for (Map.Entry entry : definitions.entrySet()) {
            String curFieldName = (String)entry.getKey();
            Definition curFieldDef = (Definition)entry.getValue();
            CtfTmfEventField curField = CtfTmfEventField.parseField(curFieldDef, curFieldName);
            fields.add(curField);
        }
        return fields.toArray(new CtfTmfEventField[fields.size()]);
    }

    public CtfTmfEvent(CtfTmfEvent other) {
        this.fTrace = other.getTrace();
        this.timestamp = other.timestamp;
        this.sourceCPU = other.sourceCPU;
        this.typeId = other.typeId;
        this.eventName = other.eventName;
        this.fileName = other.fileName;
        this.fContent = (CtfTmfContent)other.fContent.clone();
    }

    public CtfTmfEvent() {
        this.fTrace = null;
        this.timestamp = -1L;
        this.sourceCPU = -1;
        this.typeId = -1L;
        this.fileName = NO_STREAM;
        this.eventName = EMPTY_CTF_EVENT_NAME;
        this.fContent = new CtfTmfContent("", new CtfTmfEventField[0]);
    }

    public static CtfTmfEvent getNullEvent() {
        if (nullEvent == null) {
            nullEvent = new CtfTmfEvent();
        }
        return nullEvent;
    }

    public long getTimestampValue() {
        return this.timestamp;
    }

    public int getCPU() {
        return this.sourceCPU;
    }

    public long getID() {
        return this.typeId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getChannelName() {
        return this.fileName;
    }

    public CtfTmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getRank() {
        return 0L;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        if (this.fTimestamp == null) {
            this.fTimestamp = new CtfTmfTimestamp(this.timestamp);
        }
        return this.fTimestamp;
    }

    @Override
    public String getSource() {
        if (this.fSource == null) {
            this.fSource = Integer.toString(this.getCPU());
        }
        return this.fSource;
    }

    @Override
    public ITmfEventType getType() {
        if (this.type == null) {
            this.type = new CtfTmfEventType(CONTEXT_ID, this.eventName, this.fContent);
        }
        return this.type;
    }

    @Override
    public ITmfEventField getContent() {
        return this.fContent;
    }

    @Override
    public String getReference() {
        if (this.fReference == null) {
            this.fReference = this.getChannelName();
        }
        return this.fReference;
    }

    @Override
    public CtfTmfEvent clone() {
        return new CtfTmfEvent(this);
    }
}

