/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.PatternSyntaxException;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.table.TableParser;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.ParsingWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SelectTableParsingWizardPage
extends ParsingWizardPage {
    protected Text txtDelim;

    public SelectTableParsingWizardPage() {
        super("selectTableDataSetParsing");
        this.setTitle(Localization.getString("SelectTableParsingWizardPage.SelectTableDataSetParsing"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = new Composite(parent, 0);
        Label l = new Label(comp, 0);
        l.setText(Localization.getString("SelectTableParsingWizardPage.TableDelimiter"));
        l.setBounds(5, 350, 150, 25);
        this.txtDelim = new Text(comp, 2052);
        this.createColumnSelector(comp);
        this.txtDelim.setBounds(160, 350, 200, 25);
        this.txtDelim.addModifyListener(this.textListener);
        this.setControl((Control)comp);
    }

    protected boolean readParsingExpression() {
        int i;
        IMemento[] children;
        FileReader reader;
        block13: {
            block12: {
                block11: {
                    if (this.wizard.metaFile == null && !this.wizard.openFile()) {
                        return false;
                    }
                    reader = new FileReader(this.wizard.metaFile);
                    if (reader.ready()) break block11;
                    return false;
                }
                XMLMemento data = XMLMemento.createReadRoot((Reader)reader, (String)"DataSetSettings");
                children = data.getChildren("File");
                i = 0;
                while (i < children.length) {
                    if (children[i].getID().equals(this.wizard.scriptFile)) break;
                    ++i;
                }
                if (i < children.length) break block12;
                return false;
            }
            if (children[i].getString("dataset").compareTo("org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.tabledataset") == 0) break block13;
            return false;
        }
        try {
            IMemento[] children2 = children[i].getChildren("Column");
            this.txtSeries.setText("" + children2.length);
            int j = 0;
            while (j < children2.length) {
                this.txtRegExpr[j * 3].setText(children2[j].getString("name"));
                ++j;
            }
            children2 = children[i].getChildren("Series");
            this.txtSeries.setText("" + children2.length);
            j = 0;
            while (j < children2.length) {
                this.txtRegExpr[j * 3 + 1].setText(children2[j].getString("parsingExpression"));
                this.txtRegExpr[j * 3 + 2].setText(children2[j].getString("parsingSpacer"));
                ++j;
            }
            this.txtDelim.setText(children[i].getChild("Delimiter").getString("parsingExpression"));
            reader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (WorkbenchException workbenchException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected void copyExisting(IMemento oldMeta, IMemento newMeta) {
        IMemento child;
        IMemento[] children = oldMeta.getChildren("Column");
        int j = 0;
        while (j < children.length) {
            child = newMeta.createChild("Column");
            child.putString("name", children[j].getString("name"));
            ++j;
        }
        children = oldMeta.getChildren("Series");
        j = 0;
        while (j < children.length) {
            child = newMeta.createChild("Series");
            child.putString("parsingExpression", children[j].getString("parsingExpression"));
            child.putString("parsingSpacer", children[j].getString("parsingSpacer"));
            ++j;
        }
        newMeta.createChild("Delimiter").putString("parsingExpression", oldMeta.getChild("Delimiter").getString("parsingExpression"));
    }

    public boolean checkComplete() {
        if (super.checkComplete() && this.txtDelim.getText().length() > 0) {
            try {
                this.wizard.parser = new TableParser(this.regEx, this.txtDelim.getText());
                this.wizard.dataSet = DataSetFactory.createDataSet("org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.tabledataset", this.labels);
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        this.wizard.parser = null;
        this.wizard.dataSet = null;
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.txtDelim != null) {
            this.txtDelim.removeModifyListener(this.textListener);
            this.txtDelim.dispose();
            this.txtDelim = null;
        }
    }
}

