/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.graphing.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingPerspective;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ImportDataSetAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String id;
    private String[] labels;

    public void init(IWorkbenchWindow window) {
        LogManager.logDebug((String)"Start ImportDataSetAction.init", (Object)((Object)this));
        LogManager.logDebug((String)"Initializing", (Object)((Object)this));
        this.fWindow = window;
        LogManager.logDebug((String)"End ImportDataSetAction.init", (Object)((Object)this));
    }

    public void run(IAction act) {
        LogManager.logDebug((String)"Start ImportDataSetAction.run", (Object)((Object)this));
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4096);
        dialog.setText(Localization.getString("ImportDataSetAction.OpenDataSetFile"));
        String fileName = dialog.open();
        File f = null;
        if (fileName == null || fileName.length() <= 0) {
            return;
        }
        f = new File(fileName);
        if (!f.exists() || !f.canRead()) {
            return;
        }
        IDataSet dataSet = this.readFile(f);
        if (dataSet == null) {
            this.displayError(Localization.getString("ImportDataSetAction.ErrorReadingDataSet"));
            return;
        }
        try {
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(GraphingPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            IViewPart ivp = p.findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
            ((GraphSelectorView)ivp).createScriptSet(fileName, dataSet);
        }
        catch (WorkbenchException we) {
            LogManager.logCritical((String)("WorkbenchException ImportDataSetAction.run:" + we.getMessage()), (Object)((Object)this));
        }
        LogManager.logDebug((String)"End ImportDataSetAction.run", (Object)((Object)this));
    }

    public void selectionChanged(IAction a, ISelection s) {
    }

    private IDataSet readFile(File f) {
        LogManager.logDebug((String)"Start ImportDataSetAction.readFile", (Object)((Object)this));
        this.readHeader(f);
        if (this.labels == null || this.id == null) {
            return null;
        }
        IFilteredDataSet data = DataSetFactory.createFilteredDataSet((String)this.id, (String[])this.labels);
        data.readFromFile(f);
        LogManager.logDebug((String)"End ImportDataSetAction.readFile", (Object)((Object)this));
        return data;
    }

    private void readHeader(File f) {
        LogManager.logDebug((String)"Start ImportDataSetAction.readLabels", (Object)((Object)this));
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.id = br.readLine();
            String line = br.readLine();
            this.labels = line.split(", ");
        }
        catch (FileNotFoundException fnfe) {
            LogManager.logCritical((String)("FileNotFoundException ImportDataSetAction.readLabels:" + fnfe.getMessage()), (Object)((Object)this));
        }
        catch (IOException ioe) {
            LogManager.logCritical((String)("IOException ImportDataSetAction.readLabels:" + ioe.getMessage()), (Object)((Object)this));
        }
        LogManager.logDebug((String)"End ImportDataSetAction.readLabels", (Object)((Object)this));
    }

    private void displayError(String message) {
        LogManager.logInfo((String)"Initializing", MessageDialog.class);
        MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("ImportDataSetAction.Problem"), (String)message);
        LogManager.logInfo((String)"Disposing", MessageDialog.class);
    }

    public void dispose() {
        LogManager.logDebug((String)"Start ImportDataSetAction.dispose", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        this.fWindow = null;
        LogManager.logDebug((String)"End ImportDataSetAction.dispose", (Object)((Object)this));
    }
}

