/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.ActivateGraphAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardGraphData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.GraphTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ModuleView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class ActiveModuleBrowserView
extends ModuleView {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView";

    public ActiveModuleBrowserView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    protected void generateModuleTree() {
        this.viewer.setInput((Object)new TreeNode((Object)"root", "", false));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
    }

    protected void makeActions() {
        MenuManager manager = new MenuManager("modulePopup");
        Control control = this.viewer.getControl();
        manager.add((IContributionItem)new Separator("file.ext"));
        manager.add((IContributionItem)new Separator("build.ext"));
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
        super.makeActions();
    }

    public void add(String display, ActiveModuleData data) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        Cursor cursor = new Cursor((Device)disp, 1);
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(cursor);
        TreeNode root = (TreeNode)this.viewer.getInput();
        ActiveModuleTreeNode child = new ActiveModuleTreeNode(data, display, true);
        root.add((TreeNode)child);
        int i = 0;
        while (i < data.module.graphs.length) {
            DashboardGraphData graphData = new DashboardGraphData();
            graphData.data = data.data;
            graphData.filters = new IDataSetFilter[data.module.filters[i].size()];
            data.module.filters[i].toArray(graphData.filters);
            graphData.graph = data.module.graphs[i];
            graphData.moduleName = data.module.category;
            graphData.adapter = null;
            ActivateGraphAction act = new ActivateGraphAction();
            GraphTreeNode graphNode = new GraphTreeNode(graphData, data.module.graphs[i].title, true);
            act.run(graphNode, data.module.getcategory());
            child.add(graphNode);
            ++i;
        }
        root.sortLevel();
        this.viewer.refresh();
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(null);
        cursor.dispose();
    }

    public ActiveModuleData pause(DashboardModule mod) {
        TreeNode tree = (TreeNode)this.viewer.getInput();
        int i = 0;
        while (i < tree.getChildCount()) {
            if (tree.getChildAt(i).toString().equals(String.valueOf(mod.category) + "." + mod.display)) {
                return (ActiveModuleData)tree.getChildAt(i).getData();
            }
            ++i;
        }
        return null;
    }

    public ActiveModuleTreeNode remove(DashboardModule mod) {
        TreeNode tree = (TreeNode)this.viewer.getInput();
        int i = 0;
        while (i < tree.getChildCount()) {
            if (tree.getChildAt(i).toString().equals(String.valueOf(mod.category) + "." + mod.display)) {
                ActiveModuleTreeNode node = (ActiveModuleTreeNode)tree.getChildAt(i);
                tree.remove(i);
                this.viewer.refresh();
                return node;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive(DashboardModule mod) {
        try {
            TreeNode tree = (TreeNode)this.viewer.getInput();
            int i = 0;
            while (true) {
                if (i >= tree.getChildCount()) {
                    return false;
                }
                if (tree.getChildAt(i).toString().equals(String.valueOf(mod.category) + "." + mod.display)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isPaused(DashboardModule mod) {
        try {
            TreeNode tree = (TreeNode)this.viewer.getInput();
            int i = 0;
            while (i < tree.getChildCount()) {
                if (tree.getChildAt(i).toString().equals(String.valueOf(mod.category) + "." + mod.display)) {
                    return ((ActiveModuleData)tree.getChildAt((int)i).getData()).paused;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean anyRunning() {
        TreeNode tree = (TreeNode)this.viewer.getInput();
        return tree.getChildCount() > 0;
    }

    public void dispose() {
        LogManager.logInfo((String)"disposing", (Object)((Object)this));
        super.dispose();
        this.viewer = null;
    }

    private class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            TreeNode treeObj = (TreeNode)obj;
            Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            if (treeObj.getChildCount() > 0) {
                img = DashboardPlugin.getImageDescriptor("icons/misc/module_obj.gif").createImage();
            } else if (treeObj instanceof GraphTreeNode) {
                img = ((DashboardGraphData)((GraphTreeNode)treeObj).getData()).adapter == null ? DashboardPlugin.getImageDescriptor("icons/misc/graph_dis.gif").createImage() : DashboardPlugin.getImageDescriptor("icons/misc/graph_act.gif").createImage();
            }
            return img;
        }
    }
}

