/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class RPMBuild {
    private static final String DEFINE = "--define";
    private String[] macroDefines;
    private String rpmBuildCmd;
    private String buildFolder;

    public RPMBuild(IProjectConfiguration config) {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.core");
        this.rpmBuildCmd = node.get("RPMBUILD_CMD", "");
        if (config.getSourcesFolder().getLocation() == null) {
            this.buildFolder = config.getBuildFolder().getLocationURI().toString();
            String fullRemoteDirectory = config.getSourcesFolder().getLocationURI().toString();
            String host = config.getSourcesFolder().getLocationURI().getHost();
            int startIndex = fullRemoteDirectory.indexOf(host) + host.length();
            String remoteDirectory = fullRemoteDirectory.substring(startIndex);
            String[] tmpMacroDefines = new String[]{"-v", DEFINE, "_sourcedir " + remoteDirectory + "/" + "SOURCES", DEFINE, "_srcrpmdir " + remoteDirectory + "/" + "SRPMS", DEFINE, "_builddir " + remoteDirectory + "/" + "BUILD", DEFINE, "_rpmdir " + remoteDirectory + "/" + "RPMS", DEFINE, "_specdir " + remoteDirectory + "/" + "SPECS"};
            this.macroDefines = tmpMacroDefines;
        } else {
            String[] tmpMacroDefines = new String[]{this.rpmBuildCmd, "-v", DEFINE, "_sourcedir " + config.getSourcesFolder().getLocation().toOSString(), DEFINE, "_srcrpmdir " + config.getSrpmsFolder().getLocation().toOSString(), DEFINE, "_builddir " + config.getBuildFolder().getLocation().toOSString(), DEFINE, "_rpmdir " + config.getRpmsFolder().getLocation().toOSString(), DEFINE, "_specdir " + config.getSpecsFolder().getLocation().toOSString()};
            this.macroDefines = tmpMacroDefines;
        }
    }

    public void buildPrep(IResource specFile, OutputStream outStream) throws CoreException {
        this.build(specFile, outStream, "-bp");
    }

    public int buildBinary(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bb");
    }

    public int buildAll(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-ba");
    }

    public int buildSource(IResource specFile, OutputStream outStream) throws CoreException {
        return this.build(specFile, outStream, "-bs");
    }

    public int build(IResource specFile, OutputStream outStream, String buildParameter) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        IRemoteCommandLauncher rmtCmdLauncher = null;
        command.addAll(Arrays.asList(this.macroDefines));
        command.add(buildParameter);
        String remoteSpec = "";
        if (specFile.getLocation() == null) {
            RemoteProxyManager rmtProxyMgr = RemoteProxyManager.getInstance();
            try {
                rmtCmdLauncher = rmtProxyMgr.getLauncher(new URI(this.buildFolder));
            }
            catch (URISyntaxException e1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e1.getMessage(), (Throwable)e1));
            }
            String host = specFile.getLocationURI().getHost();
            int startIndex = this.buildFolder.indexOf(host) + host.length();
            remoteSpec = specFile.getLocationURI().toString().substring(startIndex);
            command.add(remoteSpec);
            String[] empty = new String[]{};
            Process pProxy = rmtCmdLauncher.execute(Path.fromOSString((String)this.rpmBuildCmd), command.toArray(new String[command.size()]), empty, null, (IProgressMonitor)new NullProgressMonitor());
            MessageConsole console = new MessageConsole("rpmbuild", null);
            console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            MessageConsoleStream stream = console.newMessageStream();
            if (pProxy != null) {
                BufferedReader error = new BufferedReader(new InputStreamReader(pProxy.getErrorStream()));
                try {
                    String err = error.readLine();
                    while (err != null) {
                        stream.println(err);
                        err = error.readLine();
                    }
                    error.close();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(pProxy.getInputStream()));
                    String readLine = reader.readLine();
                    while (readLine != null) {
                        stream.println(readLine);
                        readLine = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
                }
            }
            return Status.OK_STATUS.getCode();
        }
        command.add(specFile.getLocation().toString());
        try {
            return Utils.runCommand(outStream, command.toArray(new String[command.size()]));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), (Throwable)e));
        }
    }
}

