/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.timeframe;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.ui.views.timeframe.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.views.timeframe.SpinnerGroup;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;

@Deprecated
public class TimeFrameView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.timeframe";
    private ITmfTimestamp fTraceStartTime = new TmfTimestamp();
    private ITmfTimestamp fTraceEndTime = new TmfTimestamp();
    private ITmfTimestamp fCurrentTime = new TmfTimestamp();
    private TmfTimeRange fTraceTimeRange = new TmfTimeRange(this.fTraceStartTime, this.fTraceEndTime);
    private TmfTimeRange fTraceSpan = new TmfTimeRange(this.fTraceStartTime, this.fTraceEndTime);
    private int fScale = 0;
    private static final String START_TIME_LABEL = Messages.TimeFrameView_WindowStartTime;
    private static final String END_TIME_LABEL = Messages.TimeFrameView_WindowEndTime;
    private static final String TIME_RANGE_LABEL = Messages.TimeFrameView_WindowRange;
    private static final String CURRENT_TIME_LABEL = Messages.TimeFrameView_CurrentTime;
    private static final int SLIDER_RANGE = 10000;
    private SpinnerGroup fStartGroup;
    private SpinnerGroup fEndGroup;
    private SpinnerGroup fRangeGroup;
    private SpinnerGroup fCurrentGroup;
    private Slider fSlider;
    TmfExperiment<LttngEvent> fExperiment = null;
    private boolean fupdateExternalListeners = true;

    public TimeFrameView() {
        super("TimeFrameView");
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(4, true);
        parent.setLayout((Layout)layout);
        this.fStartGroup = new SpinnerGroup(this, parent, START_TIME_LABEL, this.fTraceTimeRange, this.fTraceStartTime);
        this.fEndGroup = new SpinnerGroup(this, parent, END_TIME_LABEL, this.fTraceTimeRange, this.fTraceEndTime);
        this.fRangeGroup = new SpinnerGroup(this, parent, TIME_RANGE_LABEL, this.fTraceTimeRange, this.fTraceEndTime);
        this.fCurrentGroup = new SpinnerGroup(this, parent, CURRENT_TIME_LABEL, this.fTraceTimeRange, this.fTraceStartTime);
        this.createSlider(parent);
    }

    public void setFocus() {
    }

    public void synchTimeFrameWidgets(SpinnerGroup trigger) {
        boolean trangeUpdated = false;
        ITmfTimestamp startTime = this.fStartGroup.getCurrentTime();
        ITmfTimestamp endTime = this.fEndGroup.getCurrentTime();
        ITmfTimestamp timeRange = this.fRangeGroup.getCurrentTime();
        ITmfTimestamp currentTime = this.fCurrentGroup.getCurrentTime();
        if (trigger == this.fStartGroup && startTime.compareTo(endTime, false) > 0) {
            endTime = startTime;
            trangeUpdated = true;
        }
        if (trigger == this.fEndGroup && endTime.compareTo(startTime, false) < 0) {
            startTime = endTime;
            trangeUpdated = true;
        }
        if (trigger == this.fRangeGroup) {
            long span;
            long start = startTime.getValue();
            TmfTimestamp ts = new TmfTimestamp(start + (span = timeRange.getValue()), startTime.getScale(), 0);
            if (ts.compareTo(this.fTraceEndTime, false) > 0) {
                ts = this.fTraceEndTime.clone();
            }
            endTime = ts;
            trangeUpdated = true;
        }
        TmfTimeRange subrange = new TmfTimeRange(startTime, endTime);
        TmfTimestamp interval = (TmfTimestamp)startTime.getDelta(endTime);
        this.fStartGroup.setContent(this.fTraceTimeRange, startTime);
        this.fEndGroup.setContent(this.fTraceTimeRange, endTime);
        this.fRangeGroup.setContent(this.fTraceSpan, (ITmfTimestamp)interval);
        this.fCurrentGroup.setContent(subrange, currentTime);
        this.updateSlider(subrange, currentTime);
        if (this.fupdateExternalListeners) {
            if (!this.fCurrentTime.equals(currentTime)) {
                this.fCurrentTime = currentTime;
                this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)this, currentTime));
            }
            if (trangeUpdated) {
                TmfTimeRange trange = new TmfTimeRange(startTime, endTime);
                this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)this, trange, currentTime));
            }
        }
    }

    private void createSlider(Composite parent) {
        this.fSlider = new Slider(parent, 65540);
        this.fSlider.setMinimum(0);
        this.fSlider.setMaximum(10000 + this.fSlider.getThumb());
        this.fSlider.setIncrement(100);
        this.fSlider.setPageIncrement(1000);
        this.fSlider.setSelection(0);
        GridData gridData = new GridData(16384, 128, true, false);
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 4;
        this.fSlider.setLayoutData((Object)gridData);
        this.fSlider.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int ratio = TimeFrameView.this.fSlider.getSelection();
                TmfTimestamp span = TimeFrameView.this.fCurrentGroup.getSpan();
                long value = span.getValue() * (long)ratio / 10000L;
                ITmfTimestamp start = TimeFrameView.this.fCurrentGroup.getStartTime();
                TmfTimestamp current = new TmfTimestamp(start.getValue() + value, start.getScale(), 0);
                TimeFrameView.this.fCurrentGroup.setValue((ITmfTimestamp)current);
            }
        });
    }

    private void updateSlider(TmfTimeRange range, ITmfTimestamp timestamp) {
        long current;
        if (this.fSlider.isDisposed()) {
            return;
        }
        long total = range.getStartTime().getDelta(range.getEndTime()).getValue();
        long relative = range.getStartTime().getDelta(timestamp).getValue();
        final long position = total > 0L ? relative * 10000L / total : 0L;
        if (position != (current = (long)this.fSlider.getSelection())) {
            this.fSlider.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TimeFrameView.this.fSlider.setSelection((int)position);
                }
            });
        }
    }

    public String toString() {
        return "[TimeFrameView]";
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<LttngEvent> signal) {
        this.fExperiment = signal.getExperiment();
        this.fTraceTimeRange = this.fExperiment.getTimeRange();
        this.fTraceStartTime = this.fTraceTimeRange.getStartTime();
        this.fTraceEndTime = this.fTraceTimeRange.getEndTime();
        this.fScale = this.fTraceStartTime.getScale();
        this.fStartGroup.setContent(this.fTraceTimeRange, this.fTraceStartTime);
        this.fEndGroup.setContent(this.fTraceTimeRange, this.fTraceEndTime);
        this.fCurrentGroup.setContent(this.fTraceTimeRange, this.fTraceStartTime);
        this.fCurrentTime = this.fTraceStartTime;
        ITmfTimestamp delta = this.fTraceStartTime.getDelta(this.fTraceEndTime);
        this.fTraceSpan = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(0L, this.fScale, 0), delta);
        TmfTimestamp start = new TmfTimestamp(1L, -1, 0);
        this.fRangeGroup.setContent(this.fTraceSpan, (ITmfTimestamp)start);
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
        if (signal.getExperiment() != this.fExperiment) {
            return;
        }
        this.fTraceTimeRange = signal.getExperiment().getTimeRange();
        this.fTraceStartTime = this.fTraceTimeRange.getStartTime();
        this.fTraceEndTime = this.fTraceTimeRange.getEndTime();
        this.fScale = this.fTraceStartTime.getScale();
        this.fStartGroup.setContent(this.fTraceTimeRange, this.fStartGroup.getCurrentTime());
        this.fEndGroup.setContent(this.fTraceTimeRange, this.fTraceEndTime);
        this.fCurrentGroup.setContent(this.fTraceTimeRange, this.fCurrentGroup.getCurrentTime());
        ITmfTimestamp delta = this.fTraceStartTime.getDelta(this.fTraceEndTime);
        this.fTraceSpan = new TmfTimeRange((ITmfTimestamp)new TmfTimestamp(0L, this.fScale, 0), delta);
        this.fRangeGroup.setContent(this.fTraceSpan, delta);
    }

    @TmfSignalHandler
    public void currentTimeRangeUpdated(TmfRangeSynchSignal signal) {
        if (signal.getSource() != this) {
            TmfTimeRange selTimeRange = signal.getCurrentRange();
            ITmfTimestamp selStart = selTimeRange.getStartTime().normalize(0L, this.fScale);
            ITmfTimestamp selEnd = selTimeRange.getEndTime().normalize(0L, this.fScale);
            this.fupdateExternalListeners = false;
            this.fStartGroup.setContent(this.fTraceTimeRange, selStart);
            this.fEndGroup.setContent(this.fTraceTimeRange, selEnd);
            ITmfTimestamp delta = selStart.getDelta(selEnd);
            this.fRangeGroup.setContent(this.fTraceSpan, delta);
            this.fupdateExternalListeners = true;
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        if (signal.getSource() != this) {
            this.fupdateExternalListeners = false;
            this.fCurrentTime = signal.getCurrentTime().normalize(0L, this.fStartGroup.getCurrentTime().getScale());
            if (this.fStartGroup.getCurrentTime().compareTo(this.fCurrentTime, false) > 0) {
                this.fStartGroup.setContent(new TmfTimeRange(this.fCurrentTime, this.fEndGroup.getCurrentTime()), this.fCurrentTime);
            }
            if (this.fEndGroup.getCurrentTime().compareTo(this.fCurrentTime, false) < 0) {
                this.fEndGroup.setContent(new TmfTimeRange(this.fStartGroup.getCurrentTime(), this.fCurrentTime), this.fCurrentTime);
            }
            this.fCurrentGroup.setContent(null, this.fCurrentTime);
            this.updateSlider(this.fCurrentGroup.getTimeRange(), this.fCurrentTime);
            this.fupdateExternalListeners = true;
        }
    }
}

