/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.statistics;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.lttng.core.model.LTTngTreeNode;
import org.eclipse.linuxtools.internal.lttng.core.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.AbsEventToHandlerResolver;
import org.eclipse.linuxtools.internal.lttng.core.state.experiment.StateManagerFactory;
import org.eclipse.linuxtools.internal.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.AbsTimeUpdateView;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.evProcessor.StatsTimeCountHandlerFactory;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.KernelStatisticsData;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsTreeNode;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsTreeRootFactory;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class StatisticsView
extends AbsTimeUpdateView {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.statistics";
    private TreeViewer treeViewer;
    private final String LEVEL_COLUMN = Messages.StatisticsView_LevelColumn;
    private final String EVENTS_COUNT_COLUMN = Messages.StatisticsView_NbEventsColumn;
    private final String CPU_TIME_COLUMN = Messages.StatisticsView_CPUTimeColumn;
    private final String CUMULATIVE_CPU_TIME_COLUMN = Messages.StatisticsView_CumCPUTimeColumn;
    private final String ELAPSED_TIME_COLUMN = Messages.StatisticsView_ElapsedTimeColumn;
    private final String LEVEL_COLUMN_TIP = Messages.StatisticsView_LevelColumnTip;
    private final String EVENTS_COUNT_COLUMN_TIP = Messages.StatisticsView_NbEventsTip;
    private final String CPU_TIME_COLUMN_TIP = Messages.StatisticsView_CPUTimeTip;
    private final String CUMULATIVE_CPU_TIME_COLUMN_TIP = Messages.StatisticsView_CumCPUTimeTip;
    private final String ELAPSED_TIME_COLUMN_TIP = Messages.StatisticsView_ElapsedTimeTip;
    private Set<Integer> folderLevels = new HashSet<Integer>(Arrays.asList(-1073741568, -1073741567, -1073741566, -1073741565, -1073741564, -1073741563));
    private Set<Integer> levelsWithEmptyTime = new HashSet<Integer>(Arrays.asList(-1073741567));
    private DecimalFormat decimalFormat = new DecimalFormat("0.#########");
    private Cursor fwaitCursor = null;
    private static final Long STATS_INPUT_CHANGED_REFRESH = 5000L;
    private boolean fStatisticsUpdateBusy = false;
    private boolean fStatisticsUpdatePending = false;
    private TmfTimeRange fStatisticsUpdateRange = null;
    private final Object fStatisticsUpdateSyncObj = new Object();
    private boolean fClearData = true;
    private boolean fRequestData = false;
    private ColumnData[] columnDataList = new ColumnData[]{new ColumnData(this.LEVEL_COLUMN, 200, 16384, this.LEVEL_COLUMN_TIP, new ColumnLabelProvider(){

        public String getText(Object element) {
            StatisticsTreeNode node = (StatisticsTreeNode)element;
            if (StatisticsView.this.folderLevels.contains(node.getKey())) {
                return KernelStatisticsData.getCategoryFromId(node.getKey());
            }
            return node.getName();
        }

        public Image getImage(Object element) {
            StatisticsTreeNode node = (StatisticsTreeNode)element;
            if (StatisticsView.this.folderLevels.contains(node.getKey())) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }, new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            StatisticsTreeNode n1 = (StatisticsTreeNode)e1;
            StatisticsTreeNode n2 = (StatisticsTreeNode)e2;
            return n1.compareTo(n2);
        }
    }, null), new ColumnData(this.EVENTS_COUNT_COLUMN, 125, 16384, this.EVENTS_COUNT_COLUMN_TIP, new ColumnLabelProvider(){

        public String getText(Object element) {
            StatisticsTreeNode node = (StatisticsTreeNode)element;
            if (!StatisticsView.this.folderLevels.contains(node.getKey())) {
                return Long.toString(node.getValue().nbEvents);
            }
            return "";
        }
    }, new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            StatisticsTreeNode n1 = (StatisticsTreeNode)e1;
            StatisticsTreeNode n2 = (StatisticsTreeNode)e2;
            return (int)(n1.getValue().nbEvents - n2.getValue().nbEvents);
        }
    }, new ColumnPercentageProvider(){

        @Override
        public double getPercentage(StatisticsTreeNode node) {
            StatisticsTreeNode parent = node;
            while ((parent = parent.getParent()) != null && parent.getValue().nbEvents == 0L) {
            }
            if (parent == null) {
                return 0.0;
            }
            return (double)node.getValue().nbEvents / (double)parent.getValue().nbEvents;
        }
    }), new ColumnData(this.CPU_TIME_COLUMN, 125, 16384, this.CPU_TIME_COLUMN_TIP, new ColumnLabelProvider(){

        public String getText(Object element) {
            StatisticsTreeNode node = (StatisticsTreeNode)element;
            if (StatisticsView.this.folderLevels.contains(node.getKey())) {
                return "";
            }
            if (node.getParent() != null && StatisticsView.this.levelsWithEmptyTime.contains(node.getParent().getKey())) {
                return "";
            }
            return StatisticsView.this.decimalFormat.format((double)node.getValue().cpuTime / Math.pow(10.0, 9.0));
        }
    }, null, null), new ColumnData(this.CUMULATIVE_CPU_TIME_COLUMN, 155, 16384, this.CUMULATIVE_CPU_TIME_COLUMN_TIP, new ColumnLabelProvider(){

        public String getText(Object element) {
            StatisticsTreeNode node = (StatisticsTreeNode)element;
            if (StatisticsView.this.folderLevels.contains(node.getKey())) {
                return "";
            }
            if (node.getParent() != null && StatisticsView.this.levelsWithEmptyTime.contains(node.getParent().getKey())) {
                return "";
            }
            return StatisticsView.this.decimalFormat.format((double)node.getValue().cumulativeCpuTime / Math.pow(10.0, 9.0));
        }
    }, null, null), new ColumnData(this.ELAPSED_TIME_COLUMN, 100, 16384, this.ELAPSED_TIME_COLUMN_TIP, new ColumnLabelProvider(){

        public String getText(Object element) {
            StatisticsTreeNode node = (StatisticsTreeNode)element;
            if (StatisticsView.this.folderLevels.contains(node.getKey())) {
                return "";
            }
            if (node.getParent() != null && StatisticsView.this.levelsWithEmptyTime.contains(node.getParent().getKey())) {
                return "";
            }
            return StatisticsView.this.decimalFormat.format((double)node.getValue().elapsedTime / Math.pow(10.0, 9.0));
        }
    }, null, null)};
    private static final String STATISTICS_VIEW = "StatisticsView";
    private static int level = 0;

    public StatisticsView(String viewName) {
        super(viewName);
    }

    public StatisticsView() {
        this(STATISTICS_VIEW);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(parent, 2816);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.setUseHashlookup(true);
        ColumnData[] columnDataArray = this.columnDataList;
        int n = this.columnDataList.length;
        int n2 = 0;
        while (n2 < n) {
            final ColumnData columnData = columnDataArray[n2];
            final TreeViewerColumn treeColumn = new TreeViewerColumn(this.treeViewer, columnData.alignment);
            treeColumn.getColumn().setText(columnData.header);
            treeColumn.getColumn().setWidth(columnData.width);
            treeColumn.getColumn().setToolTipText(columnData.tooltip);
            if (columnData.comparator != null) {
                treeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (StatisticsView.this.treeViewer.getTree().getSortDirection() == 128 || StatisticsView.this.treeViewer.getTree().getSortColumn() != treeColumn.getColumn()) {
                            StatisticsView.this.treeViewer.setComparator(columnData.comparator);
                            StatisticsView.this.treeViewer.getTree().setSortDirection(1024);
                        } else {
                            StatisticsView.this.treeViewer.setComparator(new ViewerComparator(){

                                public int compare(Viewer viewer, Object e1, Object e2) {
                                    return -1 * columnData.comparator.compare(viewer, e1, e2);
                                }
                            });
                            StatisticsView.this.treeViewer.getTree().setSortDirection(128);
                        }
                        StatisticsView.this.treeViewer.getTree().setSortColumn(treeColumn.getColumn());
                    }
                });
            }
            treeColumn.setLabelProvider((CellLabelProvider)columnData.labelProvider);
            ++n2;
        }
        this.treeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (((StatisticsView)StatisticsView.this).columnDataList[event.index].percentageProvider != null) {
                    StatisticsTreeNode node = (StatisticsTreeNode)event.item.getData();
                    double percentage = ((StatisticsView)StatisticsView.this).columnDataList[event.index].percentageProvider.getPercentage(node);
                    if (percentage == 0.0) {
                        return;
                    }
                    if ((event.detail & 2) > 0) {
                        Color oldForeground = event.gc.getForeground();
                        event.gc.setForeground(event.item.getDisplay().getSystemColor(26));
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.gc.setForeground(oldForeground);
                        event.detail &= 0xFFFFFFFD;
                    }
                    int barWidth = (int)((double)(StatisticsView.this.treeViewer.getTree().getColumn(1).getWidth() - 8) * percentage);
                    int oldAlpha = event.gc.getAlpha();
                    Color oldForeground = event.gc.getForeground();
                    Color oldBackground = event.gc.getBackground();
                    event.gc.setAlpha(64);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                    event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                    event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                    event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                    event.gc.setForeground(oldForeground);
                    event.gc.setBackground(oldBackground);
                    event.gc.setAlpha(oldAlpha);
                    event.detail &= 0xFFFFFFF7;
                }
            }
        });
        this.treeViewer.setComparator(this.columnDataList[0].comparator);
        this.treeViewer.getTree().setSortColumn(this.treeViewer.getTree().getColumn(0));
        this.treeViewer.getTree().setSortDirection(1024);
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null) {
            TmfExperimentSelectedSignal signal = new TmfExperimentSelectedSignal((Object)this, experiment);
            this.fRequestData = true;
            this.experimentSelected((TmfExperimentSelectedSignal<? extends ITmfEvent>)signal);
        } else {
            TraceDebug.debug("No selected experiment information available");
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fwaitCursor != null) {
            this.fwaitCursor.dispose();
        }
        StatisticsTreeRootFactory.removeAll();
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    @Override
    protected Long getInputChangedRefresh() {
        return STATS_INPUT_CHANGED_REFRESH;
    }

    public AbsEventToHandlerResolver getEventProcessor() {
        return StatsTimeCountHandlerFactory.getInstance();
    }

    @Override
    protected void waitCursor(final boolean waitInd) {
        if (this.treeViewer == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        Display display = this.treeViewer.getControl().getDisplay();
        if (this.fwaitCursor == null) {
            this.fwaitCursor = new Cursor((Device)display, 1);
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (StatisticsView.this.treeViewer != null && !StatisticsView.this.treeViewer.getTree().isDisposed()) {
                    Cursor cursor = null;
                    if (waitInd) {
                        cursor = StatisticsView.this.fwaitCursor;
                    }
                    StatisticsView.this.treeViewer.getControl().setCursor(cursor);
                }
            }
        });
    }

    @Override
    public void modelUpdatePrep(TmfTimeRange timeRange, boolean clearAllData) {
        Object input = this.treeViewer.getInput();
        if (input != null && input instanceof StatisticsTreeNode && !this.treeViewer.getTree().isDisposed()) {
            if (clearAllData) {
                ((StatisticsTreeNode)input).reset();
            }
            this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!StatisticsView.this.treeViewer.getTree().isDisposed()) {
                        StatisticsView.this.treeViewer.refresh();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelInputChanged(ILttngSyntEventRequest request, boolean complete) {
        TmfExperiment experiment;
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        if (TraceDebug.isSV() && complete && (experiment = TmfExperiment.getCurrentExperiment()) != null) {
            StatisticsTreeNode node = StatisticsTreeRootFactory.getStatTreeRoot(experiment.getName());
            this.printRecursively(node);
        }
        this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!StatisticsView.this.treeViewer.getTree().isDisposed()) {
                    StatisticsView.this.treeViewer.refresh();
                }
            }
        });
        if (complete) {
            Object object = this.fStatisticsUpdateSyncObj;
            synchronized (object) {
                this.fStatisticsUpdateBusy = false;
                if (this.fStatisticsUpdatePending) {
                    this.fStatisticsUpdatePending = false;
                    this.requestData(TmfExperiment.getCurrentExperiment(), this.fStatisticsUpdateRange, false);
                }
            }
        }
    }

    private void printRecursively(StatisticsTreeNode node) {
        StringBuffer tab = new StringBuffer("");
        int i = 0;
        while (i < level) {
            tab.append("\t");
            ++i;
        }
        ++level;
        TraceDebug.traceSV(tab + node.getContent());
        if (node.hasChildren()) {
            LinkedList childreen = (LinkedList)node.getChildren();
            Collections.sort(childreen);
            for (StatisticsTreeNode statisticsTreeNode : childreen) {
                this.printRecursively(statisticsTreeNode);
            }
        }
        --level;
    }

    @Override
    public void modelIncomplete(ILttngSyntEventRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<? extends ITmfEvent> signal) {
        if (signal != null) {
            StatisticsTreeNode treeModelRoot;
            TmfExperiment experiment = signal.getExperiment();
            String experimentName = experiment.getName();
            if (StatisticsTreeRootFactory.containsTreeRoot(experimentName)) {
                int numNodeTraces;
                StatisticsTreeNode experimentTreeNode = StatisticsTreeRootFactory.getStatTreeRoot(experimentName);
                ITmfTrace[] traces = experiment.getTraces();
                LTTngTreeNode expNode = StateManagerFactory.getExperimentManager().getSelectedExperiment();
                int numTraces = experiment.getTraces().length;
                if (numTraces == (numNodeTraces = experimentTreeNode.getNbChildren())) {
                    boolean same = true;
                    int i = 0;
                    while (i < numTraces) {
                        String traceName = traces[i].getName();
                        LTTngTreeNode child = (LTTngTreeNode)expNode.getChildByName(traceName);
                        if (child == null || !experimentTreeNode.containsChild(child.getId().intValue())) {
                            same = false;
                            break;
                        }
                        ++i;
                    }
                    if (same) {
                        this.treeViewer.setInput((Object)experimentTreeNode);
                        Object object = this.fStatisticsUpdateSyncObj;
                        synchronized (object) {
                            this.fStatisticsUpdateBusy = false;
                            this.fStatisticsUpdatePending = false;
                        }
                        this.requestData(experiment, experiment.getTimeRange(), false);
                        return;
                    }
                }
            }
            if ((treeModelRoot = StatisticsTreeRootFactory.getStatTreeRoot(experiment.getName())).hasChildren()) {
                treeModelRoot.reset();
            }
            this.treeViewer.setInput((Object)treeModelRoot);
            Object object = this.fStatisticsUpdateSyncObj;
            synchronized (object) {
                this.fStatisticsUpdateBusy = false;
                this.fStatisticsUpdatePending = false;
            }
            this.fClearData = true;
            if (this.fRequestData) {
                this.requestData(experiment, experiment.getTimeRange(), this.fClearData);
                this.fRequestData = false;
            }
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        TmfExperiment experiment = signal.getExperiment();
        if (!experiment.equals(TmfExperiment.getCurrentExperiment())) {
            return;
        }
        this.requestData(experiment, signal.getRange(), this.fClearData);
        this.fClearData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestData(TmfExperiment<?> experiment, TmfTimeRange range, boolean clearingData) {
        if (experiment != null) {
            Object object = this.fStatisticsUpdateSyncObj;
            synchronized (object) {
                if (this.fStatisticsUpdateBusy) {
                    this.fStatisticsUpdatePending = true;
                    this.fStatisticsUpdateRange = range;
                    return;
                }
                this.fStatisticsUpdateBusy = true;
            }
            int index = 0;
            for (StatisticsTreeNode node : ((StatisticsTreeNode)this.treeViewer.getInput()).getChildren()) {
                index += (int)node.getValue().nbEvents;
            }
            this.eventRequest(index, range, clearingData, ITmfDataRequest.ExecutionType.BACKGROUND);
        } else {
            TraceDebug.debug("No selected experiment information available");
        }
    }

    @Override
    protected void displayModel(ITmfTimeAnalysisEntry[] items, long startBoundTime, long endBoundTime, boolean updateTimeBounds, long startVisibleWindow, long endVisibleWindow, Object source) {
    }

    @Override
    protected ParamsUpdater getParamsUpdater() {
        return null;
    }

    @Override
    protected ItemContainer<?> getItemContainer() {
        return null;
    }

    @Override
    protected int getProviderId() {
        return 0;
    }

    private static class ColumnData {
        public final String header;
        public final int width;
        public final int alignment;
        public final String tooltip;
        public final ColumnLabelProvider labelProvider;
        public final ViewerComparator comparator;
        public final ColumnPercentageProvider percentageProvider;

        public ColumnData(String h, int w, int a, String t, ColumnLabelProvider l, ViewerComparator c, ColumnPercentageProvider p) {
            this.header = h;
            this.width = w;
            this.alignment = a;
            this.tooltip = t;
            this.labelProvider = l;
            this.comparator = c;
            this.percentageProvider = p;
        }
    }

    private static interface ColumnPercentageProvider {
        public double getPercentage(StatisticsTreeNode var1);
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((StatisticsTreeNode)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((StatisticsTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((StatisticsTreeNode)element).hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

