/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class DeleteTrace
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private List<TraceResource> fSelectedTraces = new ArrayList<TraceResource>();

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    protected TraceResource getSelectedTarget() {
        if (this.fSelectedTraces.size() > 0) {
            return this.fSelectedTraces.get(0);
        }
        return null;
    }

    public void run(IAction arg0) {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.DeleteTrace_ConfirmTitle, (String)Messages.DeleteTrace_ConfirmMessage);
        if (!confirm) {
            return;
        }
        int size = this.fSelectedTraces.size();
        int i = 0;
        while (i < size) {
            TraceResource trace = this.fSelectedTraces.get(i);
            trace.getParent().removeTrace(trace);
            ISystemRegistry registry = SystemStartHere.getSystemRegistry();
            registry.fireRemoteResourceChangeEvent(2, (Object)trace, (Object)trace.getParent(), trace.getSubSystem(), null);
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedTraces.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TraceResource)) continue;
                this.fSelectedTraces.add((TraceResource)obj);
            }
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }
}

