/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;

public class TraceDebug {
    static boolean DEBUG = false;
    static boolean INFO = false;
    static boolean WARN = false;
    static boolean CFV = false;
    static boolean RV = false;
    static boolean SV = false;
    private static Plugin plugin = Activator.getDefault();
    private static String pluginID = "org.eclipse.linuxtools.lttng.ui";
    private static SimpleDateFormat stimeformat = new SimpleDateFormat("HH:mm:ss:SSS");
    private static PrintWriter fCFVfile = null;
    private static PrintWriter fRVfile = null;
    private static PrintWriter fSVfile = null;

    public static void init() {
        String svTrace;
        String rvTrace;
        String cfvTrace;
        String debugTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/debug"));
        String infoTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/info"));
        String warnTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/warn"));
        if (debugTrace != null) {
            DEBUG = Boolean.valueOf(debugTrace);
        }
        if (infoTrace != null) {
            INFO = Boolean.valueOf(infoTrace);
        }
        if (warnTrace != null) {
            WARN = Boolean.valueOf(warnTrace);
        }
        if ((cfvTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/cfv"))) != null && (CFV = Boolean.valueOf(cfvTrace).booleanValue())) {
            try {
                fCFVfile = new PrintWriter(new FileWriter("CFVTrace.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((rvTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/rv"))) != null && (RV = Boolean.valueOf(rvTrace).booleanValue())) {
            try {
                fRVfile = new PrintWriter(new FileWriter("RVTrace.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((svTrace = Platform.getDebugOption((String)(String.valueOf(pluginID) + "/sv"))) != null && (SV = Boolean.valueOf(svTrace).booleanValue())) {
            try {
                fSVfile = new PrintWriter(new FileWriter("SVTrace.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void stop() {
        if (fCFVfile != null) {
            fCFVfile.close();
            fCFVfile = null;
        }
        if (fRVfile != null) {
            fRVfile.close();
            fRVfile = null;
        }
        if (fSVfile != null) {
            fSVfile.close();
            fSVfile = null;
        }
    }

    public static void traceCFV(String trace) {
        if (CFV && fCFVfile != null) {
            fCFVfile.println(trace);
            fCFVfile.flush();
        }
    }

    public static void traceRV(String trace) {
        if (RV && fRVfile != null) {
            fRVfile.println(trace);
            fRVfile.flush();
        }
    }

    public static void traceSV(String trace) {
        if (SV && fSVfile != null) {
            fSVfile.println(trace);
            fSVfile.flush();
        }
    }

    public static void info(String message) {
        if (INFO) {
            ILog logger = plugin.getLog();
            logger.log((IStatus)new Status(1, "org.eclipse.linuxtools.lttng.ui", 0, message, null));
        }
    }

    public static void warn(String message) {
        if (WARN) {
            ILog logger = plugin.getLog();
            logger.log((IStatus)new Status(2, "org.eclipse.linuxtools.lttng.ui", 2, message, null));
        }
    }

    public static void debug(String message) {
        if (DEBUG) {
            String location = TraceDebug.getCallingLocation();
            System.out.println(String.valueOf(location) + "\n\t-> " + message);
        }
    }

    public static void debug(String message, int additionalStackLines) {
        if (DEBUG) {
            String location = TraceDebug.getCallingLocation(additionalStackLines);
            System.out.println(String.valueOf(location) + "\n\t-> " + message);
        }
    }

    public static void throwException(String message) {
        if (DEBUG) {
            try {
                TraceDebug.triggerException(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void triggerException(String message) throws Exception {
        throw new Exception(message);
    }

    private static String getCallingLocation() {
        StringBuilder sb = new StringBuilder();
        sb.append(TraceDebug.trace(Thread.currentThread().getStackTrace(), 4));
        sb.append("\n" + TraceDebug.trace(Thread.currentThread().getStackTrace(), 3));
        return sb.toString();
    }

    private static String getCallingLocation(int numOfStackLines) {
        int stackCalledFromIdx = 3;
        int earliestRequested = numOfStackLines > 0 ? stackCalledFromIdx + numOfStackLines : stackCalledFromIdx;
        StringBuilder sb = new StringBuilder();
        int i = earliestRequested;
        while (i >= stackCalledFromIdx) {
            sb.append(String.valueOf(TraceDebug.trace(Thread.currentThread().getStackTrace(), i)) + "\n");
            --i;
        }
        return sb.toString();
    }

    private static String trace(StackTraceElement[] e, int level) {
        StackTraceElement s;
        if (e != null && (s = e[level = level >= e.length ? e.length - 1 : level]) != null) {
            String simpleClassName = s.getClassName();
            String[] clsNameSegs = simpleClassName.split("\\.");
            if (clsNameSegs.length > 0) {
                simpleClassName = clsNameSegs[clsNameSegs.length - 1];
            }
            return String.valueOf(stimeformat.format(new Date())) + " " + simpleClassName + "." + s.getLineNumber() + "." + s.getMethodName();
        }
        return null;
    }

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public static boolean isINFO() {
        return INFO;
    }

    public static boolean isWARN() {
        return WARN;
    }

    public static boolean isCFV() {
        return CFV;
    }

    public static boolean isRV() {
        return RV;
    }

    public static boolean isSV() {
        return SV;
    }
}

