/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.changelog.core.Messages;
import org.eclipse.linuxtools.internal.changelog.core.actions.ChangeLogContainerContentProvider;
import org.eclipse.linuxtools.internal.changelog.core.actions.ChangeLogRootContainer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ChangeLogContainerSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private IContainer selectedContainer;
    private Text containerNameField;
    TreeViewer treeViewer;
    private IContainer initialSelection;
    private static final String DEFAULT_MSG_NEW_ALLOWED = Messages.getString("ChangeLogContainerSelectionGroup.DefaultMessageNewAllowed");
    private static final String DEFAULT_MSG_SELECT_ONLY = Messages.getString("ChangeLogContainerSelectionGroup.DefaultMessageSelectOnly");
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public ChangeLogContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, IContainer initialSelection) {
        this(parent, listener, allowNewContainerName, message, showClosedProjects, 300, 320, initialSelection);
    }

    public ChangeLogContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, int heightHint, int widthHint, IContainer initialSelection) {
        super(parent, 0);
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.showClosedProjects = showClosedProjects;
        this.initialSelection = initialSelection;
        if (message != null) {
            this.createContents(message, heightHint, widthHint);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED, heightHint, widthHint);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY, heightHint, widthHint);
        }
    }

    public void containerSelectionChanged(IContainer container) {
        this.selectedContainer = container;
        if (this.allowNewContainerName) {
            if (container == null) {
                this.containerNameField.setText("");
            } else {
                String text = TextProcessor.process((String)container.getFullPath().makeRelative().toString());
                this.containerNameField.setText(text);
                this.containerNameField.setToolTipText(text);
            }
        }
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        this.createContents(message, 300, 320);
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            GridData gd = new GridData(768);
            gd.widthHint = widthHint;
            this.containerNameField.setLayoutData((Object)gd);
            this.containerNameField.addListener(24, this.listener);
            this.containerNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        ChangeLogContainerContentProvider cp = new ChangeLogContainerContentProvider();
        cp.showClosedProjects(this.showClosedProjects);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ChangeLogContainerSelectionGroup.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (ChangeLogContainerSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        ChangeLogContainerSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        ChangeLogContainerSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        ChangeLogRootContainer root = new ChangeLogRootContainer(this.initialSelection.getProject());
        this.treeViewer.setInput((Object)root);
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String pathName = this.containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(TextProcessor.deprocess((String)pathName)).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(IContainer container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }
}

