/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.view;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelEvent;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSample;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSymbol;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.ui.PartInitException;

public class OprofileViewDoubleClickListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        TreeViewer tv = (TreeViewer)event.getSource();
        TreeSelection tsl = (TreeSelection)tv.getSelection();
        IUiModelElement element = (IUiModelElement)tsl.getFirstElement();
        try {
            if (!(element instanceof UiModelEvent || element instanceof UiModelSession || element instanceof UiModelImage)) {
                if (element instanceof UiModelSymbol) {
                    UiModelSymbol symbol = (UiModelSymbol)element;
                    String fileName = symbol.getFileName();
                    int line = symbol.getLineNumber();
                    ProfileUIUtils.openEditorAndSelect((String)fileName, (int)line);
                } else if (element instanceof UiModelSample) {
                    UiModelSample sample = (UiModelSample)element;
                    int line = sample.getLine();
                    String fileName = sample.getFile();
                    ProfileUIUtils.openEditorAndSelect((String)fileName, (int)line);
                }
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (PartInitException e2) {
            e2.printStackTrace();
        }
    }
}

