/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.event;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;

public class LttngTimestamp
extends TmfTimestamp {
    public LttngTimestamp() {
        this(Long.MIN_VALUE);
    }

    public LttngTimestamp(long newEventTime) {
        super(newEventTime, -9, 0);
    }

    public LttngTimestamp(ITmfTimestamp oldEventTime) {
        this(oldEventTime.getValue());
    }

    public void setValue(long newValue) {
        this.fValue = newValue;
    }

    public String getSeconds() {
        return this.formatSecs(this.fValue);
    }

    public String getNanoSeconds() {
        return this.formatNs(this.fValue);
    }

    private String formatSecs(long time) {
        long sec = (long)((double)time * 1.0E-9);
        return String.valueOf(sec);
    }

    private String formatNs(long time) {
        boolean neg;
        boolean bl = neg = time < 0L;
        if (neg) {
            time = -time;
        }
        StringBuffer temp = new StringBuffer();
        long ns = time;
        if ((ns %= 1000000000L) < 10L) {
            temp.append("00000000");
        } else if (ns < 100L) {
            temp.append("0000000");
        } else if (ns < 1000L) {
            temp.append("000000");
        } else if (ns < 10000L) {
            temp.append("00000");
        } else if (ns < 100000L) {
            temp.append("0000");
        } else if (ns < 1000000L) {
            temp.append("000");
        } else if (ns < 10000000L) {
            temp.append("00");
        } else if (ns < 100000000L) {
            temp.append("0");
        }
        temp.append(ns);
        return temp.toString();
    }

    public String toString() {
        long value = this.fValue;
        if (this.fValue < 0L) {
            value = -this.fValue;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(value));
        int nbZeroes = -this.fScale - sb.length() + 1;
        int i = 0;
        while (i < nbZeroes) {
            sb.insert(i, "0");
            ++i;
        }
        sb.insert(sb.length() + this.fScale, ".");
        if (this.fValue < 0L) {
            sb.insert(0, "-");
        }
        return sb.toString();
    }

    public LttngTimestamp clone() {
        return (LttngTimestamp)super.clone();
    }

    public LttngTimestamp getDelta(ITmfTimestamp other) {
        TmfTimestamp delta = (TmfTimestamp)super.getDelta(other);
        return new LttngTimestamp((ITmfTimestamp)delta);
    }
}

