/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.internal.valgrind.core.Messages;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValgrindPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String VALGRIND_ENABLE = "VALGRIND_ENABLE";
    public static final String VALGRIND_PATH = "VALGRIND_PATH";
    private Text binText;
    private Button browseButton;
    private IPreferenceStore store;
    private Button enableButton;

    protected Control createContents(Composite parent) {
        Composite enableTop = new Composite(parent, 0);
        enableTop.setLayout((Layout)new GridLayout());
        GridData enableData = new GridData(4, 4, true, true);
        enableTop.setLayoutData((Object)enableData);
        this.enableButton = new Button(enableTop, 32);
        this.enableButton.setText(Messages.getString("ValgrindPreferencePage.Button_Enable_Valgrind"));
        this.enableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValgrindPreferencePage.this.checkValgrindEnablement();
                ValgrindPreferencePage.this.updateApplyButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite locationTop = new Composite(enableTop, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginTop = 0;
        locationTop.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        locationTop.setLayoutData((Object)data);
        Label pathLabel = new Label(locationTop, 0);
        pathLabel.setText(Messages.getString("ValgrindPreferencePage.Binary_path"));
        this.binText = new Text(locationTop, 2052);
        GridData binTextData = new GridData();
        binTextData.horizontalAlignment = 4;
        binTextData.grabExcessHorizontalSpace = true;
        this.binText.setLayoutData((Object)binTextData);
        this.binText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValgrindPreferencePage.this.updateApplyButton();
            }
        });
        this.browseButton = new Button(locationTop, 8);
        this.browseButton.setText(Messages.getString("ValgrindPreferencePage.Browse_button"));
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell();
                FileDialog dialog = new FileDialog(shell);
                String path = dialog.open();
                if (path != null) {
                    ValgrindPreferencePage.this.binText.setText(path);
                }
            }
        });
        this.loadPreferences();
        return parent;
    }

    private void checkValgrindEnablement() {
        boolean enabled = this.enableButton.getSelection();
        this.binText.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    private void loadPreferences() {
        this.enableButton.setSelection(this.store.getBoolean(VALGRIND_ENABLE));
        this.binText.setText(this.store.getString(VALGRIND_PATH));
        this.checkValgrindEnablement();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ValgrindPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        this.store = this.getPreferenceStore();
    }

    protected void performDefaults() {
        this.store.setValue(VALGRIND_ENABLE, this.store.getDefaultBoolean(VALGRIND_ENABLE));
        this.enableButton.setSelection(this.store.getDefaultBoolean(VALGRIND_ENABLE));
        this.store.setValue(VALGRIND_PATH, this.store.getDefaultString(VALGRIND_PATH));
        this.binText.setText(this.store.getDefaultString(VALGRIND_PATH));
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.isValid()) {
            boolean enabled = this.enableButton.getSelection();
            this.store.setValue(VALGRIND_ENABLE, enabled);
            if (enabled) {
                this.store.setValue(VALGRIND_PATH, this.binText.getText());
            }
            ValgrindPlugin.getDefault().savePluginPreferences();
            return true;
        }
        return false;
    }

    public boolean isValid() {
        String path;
        File file;
        this.setErrorMessage(null);
        if (this.enableButton.getSelection() && (!(file = new File(path = this.binText.getText())).exists() || file.isDirectory())) {
            this.setErrorMessage(Messages.getString("ValgrindPreferencePage.Error_invalid_message"));
            return false;
        }
        return true;
    }
}

