/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MinMaxDialog
extends Dialog {
    protected Label minLabel;
    protected Label maxLabel;
    protected Label scaleLabel;
    protected Label precisionLabel;
    protected Text minText;
    protected Text maxText;
    protected Text scaleText;
    protected Text precisionText;
    SDWidget sdWidget;

    public MinMaxDialog(Shell s, SDWidget v) {
        super(s);
        this.sdWidget = v;
    }

    protected GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    protected Control createDialogArea(Composite p) {
        p.getShell().setText(SDMessages._123);
        Composite parent = (Composite)super.createDialogArea(p);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 6;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setLayoutData((Object)this.newGridData(3));
        GridLayout g1layout = new GridLayout();
        g1layout.numColumns = 3;
        g1.setLayout((Layout)g1layout);
        this.minLabel = new Label((Composite)g1, 16);
        this.minLabel.setText(SDMessages._124);
        this.minLabel.setLayoutData((Object)this.newGridData(1));
        this.minText = new Text((Composite)g1, 2052);
        this.minText.setLayoutData((Object)this.newGridData(2));
        this.minText.setText(String.valueOf(this.sdWidget.getFrame().getMinTime().getValue()));
        this.maxLabel = new Label((Composite)g1, 16);
        this.maxLabel.setText(SDMessages._125);
        this.maxLabel.setLayoutData((Object)this.newGridData(1));
        this.maxText = new Text((Composite)g1, 2052);
        this.maxText.setLayoutData((Object)this.newGridData(2));
        this.maxText.setText(String.valueOf(this.sdWidget.getFrame().getMaxTime().getValue()));
        this.scaleLabel = new Label((Composite)g1, 16);
        this.scaleLabel.setText(SDMessages._136);
        this.scaleLabel.setLayoutData((Object)this.newGridData(1));
        this.scaleText = new Text((Composite)g1, 2052);
        this.scaleText.setLayoutData((Object)this.newGridData(2));
        this.scaleText.setText(String.valueOf(this.sdWidget.getFrame().getMinTime().getScale()));
        this.precisionLabel = new Label((Composite)g1, 16);
        this.precisionLabel.setText(SDMessages._137);
        this.precisionLabel.setLayoutData((Object)this.newGridData(1));
        this.precisionText = new Text((Composite)g1, 2052);
        this.precisionText.setLayoutData((Object)this.newGridData(2));
        this.precisionText.setText(String.valueOf(this.sdWidget.getFrame().getMinTime().getPrecision()));
        return parent;
    }

    protected void okPressed() {
        long min = 0L;
        long max = 0L;
        byte scale = 0;
        long precision = 0L;
        try {
            min = Long.parseLong(this.minText.getText());
            max = Long.parseLong(this.maxText.getText());
            scale = Byte.parseByte(this.scaleText.getText());
            precision = Long.parseLong(this.precisionText.getText());
            this.sdWidget.getFrame().setMax(new TmfTimestamp(max, scale, precision));
            this.sdWidget.getFrame().setMin(new TmfTimestamp(min, scale, precision));
            this.sdWidget.redraw();
            super.okPressed();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)SDMessages._98, (String)SDMessages._99);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1024, SDMessages._126, false);
        this.getButton(1024).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MinMaxDialog.this.sdWidget.getFrame().resetCustomMinMax();
                MinMaxDialog.this.minText.setText(String.valueOf(MinMaxDialog.this.sdWidget.getFrame().getMinTime().getValue()));
                MinMaxDialog.this.maxText.setText(String.valueOf(MinMaxDialog.this.sdWidget.getFrame().getMaxTime().getValue()));
                MinMaxDialog.this.scaleText.setText(String.valueOf(MinMaxDialog.this.sdWidget.getFrame().getMinTime().getScale()));
                MinMaxDialog.this.precisionText.setText(String.valueOf(MinMaxDialog.this.sdWidget.getFrame().getMinTime().getPrecision()));
                MinMaxDialog.this.maxText.getParent().layout(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
}

