/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DrawableToolTip
implements PaintListener {
    protected Composite parent = null;
    protected Shell toolTipShell = null;
    protected TmfTimeRange minMaxRange;
    protected TmfTimestamp currentValue;
    private static int H_MARGIN = 10;
    private static int V_MARGIN = 10;
    private static int TEXT_SCALE_MARGIN = 20;
    private static int SCALE_LENGTH = 100;
    protected String msg;
    protected Color[] col;

    public DrawableToolTip(Composite _parent) {
        this.parent = _parent;
        this.toolTipShell = new Shell(this.parent.getShell(), 16384);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(200, 50);
        this.col = new Color[10];
        this.col[0] = new Color((Device)Display.getDefault(), 255, 229, 229);
        this.col[1] = new Color((Device)Display.getDefault(), 255, 204, 204);
        this.col[2] = new Color((Device)Display.getDefault(), 255, 178, 178);
        this.col[3] = new Color((Device)Display.getDefault(), 255, 153, 153);
        this.col[4] = new Color((Device)Display.getDefault(), 255, 127, 127);
        this.col[5] = new Color((Device)Display.getDefault(), 255, 102, 102);
        this.col[6] = new Color((Device)Display.getDefault(), 255, 76, 76);
        this.col[7] = new Color((Device)Display.getDefault(), 255, 51, 51);
        this.col[8] = new Color((Device)Display.getDefault(), 255, 25, 25);
        this.col[9] = new Color((Device)Display.getDefault(), 255, 0, 0);
    }

    public void showToolTip(TmfTimestamp _value, TmfTimestamp min, TmfTimestamp max) {
        this.minMaxRange = new TmfTimeRange(min.clone(), max.clone());
        this.currentValue = _value.clone();
        int w = this.toolTipShell.getBounds().width;
        int h = this.toolTipShell.getBounds().height;
        Point hr = Display.getDefault().getCursorLocation();
        this.toolTipShell.setBounds(hr.x, hr.y + 26, w, h);
        this.toolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent event) {
        this.msg = String.valueOf(SDMessages._138) + " " + this.currentValue.toString();
        Point size = event.gc.textExtent(this.msg);
        if (size.x < SCALE_LENGTH) {
            size.x = SCALE_LENGTH;
        }
        event.gc.drawText(this.msg, H_MARGIN, V_MARGIN, true);
        event.gc.drawLine(H_MARGIN, V_MARGIN + TEXT_SCALE_MARGIN + size.y, H_MARGIN + SCALE_LENGTH, V_MARGIN + TEXT_SCALE_MARGIN + size.y);
        int step = SCALE_LENGTH / 10;
        TmfTimestamp minMaxdelta = this.minMaxRange.getEndTime().getDelta(this.minMaxRange.getStartTime());
        double gr = (double)minMaxdelta.getValue() / 10.0;
        TmfTimestamp delta = this.currentValue.getDelta(this.minMaxRange.getStartTime());
        long absDelta = Math.abs(delta.getValue());
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)((double)absDelta / gr));
            if (colIndex > this.col.length) {
                colIndex = this.col.length;
            } else if (colIndex <= 1) {
                colIndex = 1;
            }
        } else {
            colIndex = 1;
        }
        int i = 0;
        while (i <= 10) {
            if (i < 10) {
                event.gc.setBackground(this.col[i]);
            }
            if (i < colIndex && i < 10) {
                event.gc.fillRectangle(H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y - 5, step, 11);
            }
            if (i == 0) {
                event.gc.drawText(SDMessages._56, H_MARGIN, size.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
            }
            if (i == 0) {
                int len = event.gc.textExtent((String)SDMessages._55).x;
                event.gc.drawText(SDMessages._55, H_MARGIN + SCALE_LENGTH - len + 1, size.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
            }
            int lineWidth = 10;
            if (i == 0 || i == 10) {
                lineWidth = 14;
            }
            event.gc.drawLine(H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y - lineWidth / 2, H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y + lineWidth / 2);
            ++i;
        }
        this.toolTipShell.setSize(size.x + 2 * H_MARGIN + 2, 2 * size.y + 3 * V_MARGIN + TEXT_SCALE_MARGIN);
    }

    public String getText() {
        return this.msg;
    }

    public String getAccessibleText() {
        return this.currentValue.toString();
    }

    public void dispose() {
        int i = 0;
        while (i < this.col.length) {
            this.col[i].dispose();
            ++i;
        }
    }

    protected static int getHorizontalMargin() {
        return H_MARGIN;
    }

    protected static void setHorizontalMargin(int margin) {
        H_MARGIN = margin;
    }

    protected static int getVerticalMargin() {
        return V_MARGIN;
    }

    protected static void setVerticalMargin(int margin) {
        V_MARGIN = margin;
    }

    protected static int getTestScaleMargin() {
        return TEXT_SCALE_MARGIN;
    }

    protected static void setTestScaleMargin(int testScaleMargin) {
        TEXT_SCALE_MARGIN = testScaleMargin;
    }

    protected static int getScaleLength() {
        return SCALE_LENGTH;
    }

    protected static void setScaleLength(int scaleLength) {
        SCALE_LENGTH = scaleLength;
    }
}

