/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.tmf.ui.views.statistics.Messages;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.ITmfColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfBaseColumnData;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TmfBaseColumnDataProvider
implements ITmfColumnDataProvider {
    protected static Vector<TmfBaseColumnData> fColumnData = null;
    protected static final String LEVEL_COLUMN = Messages.TmfStatisticsView_LevelColumn;
    protected static final String EVENTS_COUNT_COLUMN = Messages.TmfStatisticsView_NbEventsColumn;
    protected static final String LEVEL_COLUMN_TIP = Messages.TmfStatisticsView_LevelColumnTip;
    protected static final String EVENTS_COUNT_COLUMN_TIP = Messages.TmfStatisticsView_NbEventsTip;
    protected Set<String> fFolderLevels = new HashSet<String>(Arrays.asList("Event Types"));

    public TmfBaseColumnDataProvider() {
        fColumnData = new Vector();
        fColumnData.add(new TmfBaseColumnData(LEVEL_COLUMN, 200, 16384, LEVEL_COLUMN_TIP, new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TmfStatisticsTreeNode)element).getKey();
            }

            public Image getImage(Object element) {
                TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)element;
                if (TmfBaseColumnDataProvider.this.fFolderLevels.contains(node.getKey())) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        }, new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TmfStatisticsTreeNode n1 = (TmfStatisticsTreeNode)e1;
                TmfStatisticsTreeNode n2 = (TmfStatisticsTreeNode)e2;
                return n1.getKey().compareTo(n2.getKey());
            }
        }, null));
        fColumnData.add(new TmfBaseColumnData(EVENTS_COUNT_COLUMN, 125, 16384, EVENTS_COUNT_COLUMN_TIP, new ColumnLabelProvider(){

            public String getText(Object element) {
                TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)element;
                if (!TmfBaseColumnDataProvider.this.fFolderLevels.contains(node.getKey())) {
                    return Long.toString(node.getValue().nbEvents);
                }
                return "";
            }
        }, new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TmfStatisticsTreeNode n1 = (TmfStatisticsTreeNode)e1;
                TmfStatisticsTreeNode n2 = (TmfStatisticsTreeNode)e2;
                return (int)(n1.getValue().nbEvents - n2.getValue().nbEvents);
            }
        }, new TmfBaseColumnData.ITmfColumnPercentageProvider(){

            @Override
            public double getPercentage(TmfStatisticsTreeNode node) {
                TmfStatisticsTreeNode parent = node;
                while ((parent = parent.getParent()) != null && parent.getValue().nbEvents == 0L) {
                }
                if (parent == null) {
                    return 0.0;
                }
                return (double)node.getValue().nbEvents / (double)parent.getValue().nbEvents;
            }
        }));
    }

    @Override
    public Vector<TmfBaseColumnData> getColumnData() {
        return fColumnData;
    }
}

