/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SelectTraceTypeContributionItem
extends CompoundContributionItem {
    private static final ImageDescriptor SELECTED_ICON = TmfUiPlugin.getDefault().getImageDescripterFromPath("icons/elcl16/bullet.gif");

    protected IContributionItem[] getContributionItems() {
        IConfigurationElement[] config;
        LinkedList<Object> list = new LinkedList<Object>();
        HashMap<String, MenuManager> categoriesMap = new HashMap<String, MenuManager>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("category")) {
                MenuManager subMenu = new MenuManager(ce.getAttribute("name"));
                categoriesMap.put(ce.getAttribute("id"), subMenu);
                list.add(subMenu);
            }
            ++n2;
        }
        HashSet<String> selectedTraceTypes = new HashSet<String>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (!(element instanceof TmfTraceElement)) continue;
                TmfTraceElement trace = (TmfTraceElement)element;
                selectedTraceTypes.add(trace.getTraceType());
            }
        }
        IConfigurationElement[] iConfigurationElementArray2 = config;
        int n3 = config.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if (ce.getName().equals("type")) {
                String traceBundle = ce.getContributor().getName();
                String traceType = ce.getAttribute("id");
                String traceIcon = ce.getAttribute("icon");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.select_trace_type.bundle", traceBundle);
                params.put("org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.select_trace_type.type", traceType);
                params.put("org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.select_trace_type.icon", traceIcon);
                String label = ce.getAttribute("name").replaceAll("&", "&&");
                ImageDescriptor icon = null;
                if (selectedTraceTypes.contains(traceType)) {
                    icon = SELECTED_ICON;
                }
                CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "my.parameterid", "org.eclipse.linuxtools.tmf.ui.command.project.trace.select_trace_type", params, icon, icon, icon, label, null, null, 8, null, true);
                MenuManager subMenu = (MenuManager)categoriesMap.get(ce.getAttribute("category"));
                if (subMenu != null) {
                    subMenu.add((IContributionItem)new CommandContributionItem(param));
                } else {
                    list.add(new CommandContributionItem(param));
                }
            }
            ++n4;
        }
        return list.toArray(new IContributionItem[list.size()]);
    }
}

