/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.statistics.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.views.statistics.model.FixedArray;
import org.eclipse.linuxtools.lttng.ui.views.statistics.model.StatisticsTreeNode;

public abstract class StatisticsData {
    protected static StringBuilder fBuilder = new StringBuilder();
    public static final FixedArray ROOT = new FixedArray(-1);
    private Map<Integer, Set<Integer>> fKeys;
    private HashMap<FixedArray, StatisticsTreeNode> fNodes = new HashMap();

    protected static synchronized String mergeString(String ... strings) {
        fBuilder.setLength(0);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            fBuilder.append(s);
            ++n2;
        }
        return fBuilder.toString();
    }

    public StatisticsData() {
        this.fKeys = new HashMap<Integer, Set<Integer>>();
    }

    public abstract void endTraceset(LttngEvent var1, LttngTraceState var2);

    public StatisticsTreeNode get(FixedArray path) {
        return this.fNodes.get(path);
    }

    public StatisticsTreeNode put(FixedArray path, StatisticsTreeNode node) {
        return this.fNodes.put(path, node);
    }

    public abstract Collection<StatisticsTreeNode> getChildren(FixedArray var1);

    protected Map<Integer, Set<Integer>> getKeys() {
        return this.fKeys;
    }

    public StatisticsTreeNode getOrCreate(FixedArray path) {
        StatisticsTreeNode current = this.fNodes.get(path);
        if (current == null) {
            this.registerName(path);
            current = new StatisticsTreeNode(path, this);
            this.fNodes.put(path, current);
        }
        return current;
    }

    public StatisticsTreeNode getParent(FixedArray path) {
        if (path.size() == 1) {
            if (path.equals(ROOT)) {
                return null;
            }
            return this.get(ROOT);
        }
        return this.get(path.subArray(0, path.size() - 1));
    }

    public abstract void increase(LttngEvent var1, LttngTraceState var2, int var3);

    public abstract void registerEvent(LttngEvent var1, LttngTraceState var2);

    protected abstract void registerName(FixedArray var1);

    public void reset(FixedArray path) {
        for (StatisticsTreeNode node : this.getChildren(path)) {
            this.reset(node.getPath());
            this.fNodes.remove(node.getPath());
        }
    }

    public abstract void process_exit(LttngEvent var1, LttngTraceState var2);

    public static class Values {
        public static final int CPU_TIME = 1;
        public static final int CUMULATIVE_CPU_TIME = 2;
        public static final int ELAPSED_TIME = 4;
        public static final int STATE_CUMULATIVE_CPU_TIME = 8;
    }
}

