/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.model;

import java.lang.reflect.Array;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectTreeNode;

public class LTTngExperimentFolderNode
extends LTTngProjectTreeNode {
    private final IFolder fExperimentFolder;

    public LTTngExperimentFolderNode(IFolder folder) {
        this(null, folder);
    }

    public LTTngExperimentFolderNode(ILTTngProjectTreeNode parent, IFolder folder) {
        super(parent);
        this.fExperimentFolder = folder;
    }

    @Override
    public String getName() {
        return this.fExperimentFolder.getName();
    }

    @Override
    public void refreshChildren() {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fExperimentFolder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                LTTngExperimentNode node;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder && (node = this.find(resource.getName())) == null) {
                    node = new LTTngExperimentNode(this, (IFolder)resource);
                    this.fChildren.add(node);
                }
                ++n2;
            }
            for (ILTTngProjectTreeNode node : this.fChildren) {
                if (this.exists(node.getName(), resources)) {
                    node.refreshChildren();
                    continue;
                }
                this.fChildren.remove(node);
            }
        }
        catch (CoreException coreException) {}
    }

    private LTTngExperimentNode find(String name) {
        for (ILTTngProjectTreeNode node : this.fChildren) {
            if (!(node instanceof LTTngExperimentNode) || !node.getName().equals(name)) continue;
            return (LTTngExperimentNode)node;
        }
        return null;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public LTTngProjectNode getProject() {
        return (LTTngProjectNode)this.getParent();
    }

    public IFolder getFolder() {
        return this.fExperimentFolder;
    }

    public LTTngExperimentNode[] getExperiments() {
        LTTngExperimentNode[] result = (LTTngExperimentNode[])Array.newInstance(LTTngExperimentNode.class, this.fChildren.size());
        return this.fChildren.toArray(result);
    }

    public void addExperiment(IFolder experiment) {
    }
}

