/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import java.util.Arrays;

public class HistogramScaledData {
    public static final int OUT_OF_RANGE_BUCKET = -1;
    public int fWidth;
    public int fHeight;
    public int[] fData;
    public long fBucketDuration;
    public long fMaxValue;
    public int fCurrentBucket;
    public int fLastBucket;
    public double fScalingFactor;

    public HistogramScaledData(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
        this.fData = new int[width];
        Arrays.fill(this.fData, 0);
        this.fBucketDuration = 1L;
        this.fMaxValue = 0L;
        this.fCurrentBucket = 0;
        this.fLastBucket = 0;
        this.fScalingFactor = 1.0;
    }

    public HistogramScaledData(HistogramScaledData other) {
        this.fWidth = other.fWidth;
        this.fHeight = other.fHeight;
        this.fData = Arrays.copyOf(other.fData, this.fWidth);
        this.fBucketDuration = other.fBucketDuration;
        this.fMaxValue = other.fMaxValue;
        this.fCurrentBucket = other.fCurrentBucket;
        this.fLastBucket = other.fLastBucket;
        this.fScalingFactor = other.fScalingFactor;
    }
}

