/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import java.util.Arrays;
import org.eclipse.linuxtools.lttng.exceptions.EventOutOfSequenceException;
import org.eclipse.linuxtools.lttng.ui.LTTngUILogger;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramScaledData;

public class HistogramDataModel {
    public static final int DEFAULT_NUMBER_OF_BUCKETS = 16000;
    private final int fNbBuckets;
    private final long[] fBuckets;
    private long fBucketDuration;
    private long fNbEvents;
    private int fLastBucket;
    private long fFirstEventTime;
    private long fLastEventTime;
    private long fCurrentEventTime;
    private long fTimeLimit;

    public HistogramDataModel() {
        this(16000);
    }

    public HistogramDataModel(int nbBuckets) {
        this.fNbBuckets = nbBuckets;
        this.fBuckets = new long[nbBuckets];
        this.clear();
    }

    public HistogramDataModel(HistogramDataModel other) {
        this.fNbBuckets = other.fNbBuckets;
        this.fBuckets = Arrays.copyOf(other.fBuckets, this.fNbBuckets);
        this.fBucketDuration = other.fBucketDuration;
        this.fNbEvents = other.fNbEvents;
        this.fLastBucket = other.fLastBucket;
        this.fFirstEventTime = other.fFirstEventTime;
        this.fLastEventTime = other.fLastEventTime;
        this.fCurrentEventTime = other.fCurrentEventTime;
        this.fTimeLimit = other.fTimeLimit;
    }

    public long getNbEvents() {
        return this.fNbEvents;
    }

    public int getNbBuckets() {
        return this.fNbBuckets;
    }

    public long getBucketDuration() {
        return this.fBucketDuration;
    }

    public long getStartTime() {
        return this.fFirstEventTime;
    }

    public long getEndTime() {
        return this.fLastEventTime;
    }

    public long getCurrentEventTime() {
        return this.fCurrentEventTime;
    }

    public long getTimeLimit() {
        return this.fTimeLimit;
    }

    public void clear() {
        Arrays.fill(this.fBuckets, 0L);
        this.fNbEvents = 0L;
        this.fFirstEventTime = 0L;
        this.fLastEventTime = 0L;
        this.fCurrentEventTime = 0L;
        this.fLastBucket = 0;
        this.fBucketDuration = 1L;
        this.updateEndTime();
    }

    public void setCurrentEvent(long timestamp) {
        this.fCurrentEventTime = timestamp;
    }

    public void countEvent(long timestamp) {
        int index;
        if (this.fLastBucket == 0 && this.fBuckets[0] == 0L && timestamp > 0L) {
            this.fFirstEventTime = timestamp;
            this.updateEndTime();
        }
        if (this.fLastEventTime < timestamp) {
            this.fLastEventTime = timestamp;
        }
        while (timestamp >= this.fTimeLimit) {
            this.mergeBuckets();
        }
        if (timestamp < this.fFirstEventTime) {
            String message = "Out of order timestamp. Going back in time?";
            EventOutOfSequenceException exception = new EventOutOfSequenceException(message);
            LTTngUILogger.logError(message, (Throwable)exception);
            return;
        }
        int n = index = (int)((timestamp - this.fFirstEventTime) / this.fBucketDuration);
        this.fBuckets[n] = this.fBuckets[n] + 1L;
        ++this.fNbEvents;
        if (this.fLastBucket < index) {
            this.fLastBucket = index;
        }
    }

    public HistogramScaledData scaleTo(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new AssertionError((Object)("Invalid histogram dimensions (" + width + "x" + height + ")"));
        }
        HistogramScaledData result = new HistogramScaledData(width, height);
        result.fMaxValue = 0L;
        int bucketsPerBar = this.fLastBucket / width + 1;
        result.fBucketDuration = (long)bucketsPerBar * this.fBucketDuration;
        int i = 0;
        while (i < width) {
            int count = 0;
            int j = i * bucketsPerBar;
            while (j < (i + 1) * bucketsPerBar) {
                if (this.fNbBuckets <= j) break;
                count = (int)((long)count + this.fBuckets[j]);
                ++j;
            }
            result.fData[i] = count;
            result.fLastBucket = i;
            if (result.fMaxValue < (long)count) {
                result.fMaxValue = count;
            }
            ++i;
        }
        if (result.fMaxValue > 0L) {
            result.fScalingFactor = (double)height / (double)result.fMaxValue;
        }
        result.fCurrentBucket = this.fCurrentEventTime >= this.fFirstEventTime && this.fCurrentEventTime <= this.fLastEventTime ? (int)((this.fCurrentEventTime - this.fFirstEventTime) / this.fBucketDuration) / bucketsPerBar : -1;
        return result;
    }

    private void updateEndTime() {
        this.fTimeLimit = this.fFirstEventTime + (long)this.fNbBuckets * this.fBucketDuration;
    }

    private void mergeBuckets() {
        int i = 0;
        while (i < this.fNbBuckets / 2) {
            this.fBuckets[i] = this.fBuckets[2 * i] + this.fBuckets[2 * i + 1];
            ++i;
        }
        Arrays.fill(this.fBuckets, this.fNbBuckets / 2, this.fNbBuckets, 0L);
        this.fBucketDuration *= 2L;
        this.updateEndTime();
        this.fLastBucket = this.fNbBuckets / 2 - 1;
    }
}

