/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramDataModel;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramScaledData;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramUtils;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramView;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class Histogram
implements ControlListener,
PaintListener,
KeyListener,
MouseListener,
MouseTrackListener {
    private static final int REFRESH_FREQUENCY = 16000;
    private final Color fBackgroundColor = Display.getCurrent().getSystemColor(1);
    private final Color fCurrentEventColor = Display.getCurrent().getSystemColor(3);
    private final Color fLastEventColor = Display.getCurrent().getSystemColor(4);
    private final Color fHistoBarColor = new Color((Device)Display.getDefault(), 74, 112, 139);
    public static final byte TIME_SCALE = -9;
    protected TmfView fParentView;
    private Text fMaxNbEventsText;
    private Text fMinNbEventsText;
    private Text fTimeRangeStartText;
    private Text fTimeRangeEndText;
    protected Canvas fCanvas;
    protected final HistogramDataModel fDataModel;
    protected HistogramScaledData fScaledData;
    protected long fCurrentEventTime = 0L;
    protected final String IMAGE_KEY = "double-buffer-image";

    public Histogram(TmfView view, Composite parent) {
        this.fParentView = view;
        this.createWidget(parent);
        this.fDataModel = new HistogramDataModel();
        this.clear();
        this.fCanvas.addControlListener((ControlListener)this);
        this.fCanvas.addPaintListener((PaintListener)this);
        this.fCanvas.addKeyListener((KeyListener)this);
        this.fCanvas.addMouseListener((MouseListener)this);
        this.fCanvas.addMouseTrackListener((MouseTrackListener)this);
    }

    public void dispose() {
        this.fHistoBarColor.dispose();
    }

    private void createWidget(Composite parent) {
        Color labelColor = parent.getDisplay().getSystemColor(34);
        Font fFont = this.adjustFont(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 128;
        this.fMaxNbEventsText = new Text(composite, 131080);
        this.fMaxNbEventsText.setFont(fFont);
        this.fMaxNbEventsText.setBackground(labelColor);
        this.fMaxNbEventsText.setEditable(false);
        this.fMaxNbEventsText.setText("0");
        this.fMaxNbEventsText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fCanvas = new Canvas(composite, 0x20000800);
        this.fCanvas.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        this.fMinNbEventsText = new Text(composite, 131080);
        this.fMinNbEventsText.setFont(fFont);
        this.fMinNbEventsText.setBackground(labelColor);
        this.fMinNbEventsText.setEditable(false);
        this.fMinNbEventsText.setText("0");
        this.fMinNbEventsText.setLayoutData((Object)gridData);
        gridData = new GridData(10, -1);
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        Text dummyText = new Text(composite, 8);
        dummyText.setFont(fFont);
        dummyText.setBackground(labelColor);
        dummyText.setEditable(false);
        dummyText.setText("");
        dummyText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 1024;
        this.fTimeRangeStartText = new Text(composite, 8);
        this.fTimeRangeStartText.setFont(fFont);
        this.fTimeRangeStartText.setBackground(labelColor);
        this.fTimeRangeStartText.setText(HistogramUtils.nanosecondsToString(0L));
        this.fTimeRangeStartText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        this.fTimeRangeEndText = new Text(composite, 8);
        this.fTimeRangeEndText.setFont(fFont);
        this.fTimeRangeEndText.setBackground(labelColor);
        this.fTimeRangeEndText.setText(HistogramUtils.nanosecondsToString(0L));
        this.fTimeRangeEndText.setLayoutData((Object)gridData);
    }

    private Font adjustFont(Composite composite) {
        int fontSizeAdjustment = -2;
        Font font = composite.getFont();
        FontData fontData = font.getFontData()[0];
        return new Font(font.getDevice(), fontData.getName(), fontData.getHeight() + fontSizeAdjustment, fontData.getStyle());
    }

    public long getStartTime() {
        return this.fDataModel.getStartTime();
    }

    public long getEndTime() {
        return this.fDataModel.getEndTime();
    }

    public long getTimeLimit() {
        return this.fDataModel.getTimeLimit();
    }

    public abstract void updateTimeRange(long var1, long var3);

    public void clear() {
        this.fDataModel.clear();
        this.fScaledData = null;
        this.refresh();
    }

    public void countEvent(long timestamp) {
        this.fDataModel.countEvent(timestamp);
        if (this.fDataModel.getNbEvents() % 16000L == 0L) {
            this.refresh();
            this.refresh();
        }
    }

    public void setCurrentEvent(long timestamp) {
        this.fCurrentEventTime = timestamp > 0L ? timestamp : 0L;
        this.fDataModel.setCurrentEvent(timestamp);
        this.refresh();
    }

    public synchronized long getTimestamp(int offset) {
        assert (offset > 0 && offset < this.fScaledData.fWidth);
        try {
            return this.fDataModel.getStartTime() + this.fScaledData.fBucketDuration * (long)offset;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public synchronized int getOffset(long timestamp) {
        if (timestamp < this.fDataModel.getStartTime() || timestamp > this.fDataModel.getEndTime()) {
            return -1;
        }
        return (int)((timestamp - this.fDataModel.getStartTime()) / this.fScaledData.fBucketDuration);
    }

    protected void moveCursor(int keyCode) {
        if (this.fScaledData.fCurrentBucket == -1) {
            return;
        }
        switch (keyCode) {
            case 0x1000007: {
                int index = 0;
                while (index < this.fScaledData.fLastBucket && this.fScaledData.fData[index] == 0) {
                    ++index;
                }
                if (index >= this.fScaledData.fLastBucket) break;
                this.fScaledData.fCurrentBucket = index;
                break;
            }
            case 0x1000004: {
                int index = this.fScaledData.fCurrentBucket + 1;
                while (index < this.fScaledData.fWidth && this.fScaledData.fData[index] == 0) {
                    ++index;
                }
                if (index >= this.fScaledData.fLastBucket) break;
                this.fScaledData.fCurrentBucket = index;
                break;
            }
            case 0x1000008: {
                int index = this.fScaledData.fLastBucket;
                while (index >= 0 && this.fScaledData.fData[index] == 0) {
                    --index;
                }
                if (index < 0) break;
                this.fScaledData.fCurrentBucket = index;
                break;
            }
            case 0x1000003: {
                int index = this.fScaledData.fCurrentBucket - 1;
                while (index >= 0 && this.fScaledData.fData[index] == 0) {
                    --index;
                }
                if (index < 0) break;
                this.fScaledData.fCurrentBucket = index;
                break;
            }
            default: {
                return;
            }
        }
        this.updateCurrentEventTime();
    }

    protected void refresh() {
        if (!this.fCanvas.isDisposed() && this.fCanvas.getDisplay() != null) {
            this.fCanvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!Histogram.this.fCanvas.isDisposed()) {
                        int canvasWidth = Histogram.this.fCanvas.getBounds().width;
                        int canvasHeight = Histogram.this.fCanvas.getBounds().height;
                        if (canvasWidth <= 0 || canvasHeight <= 0) {
                            return;
                        }
                        Histogram.this.fDataModel.setCurrentEvent(Histogram.this.fCurrentEventTime);
                        Histogram.this.fScaledData = Histogram.this.fDataModel.scaleTo(canvasWidth, canvasHeight);
                        Histogram.this.fCanvas.redraw();
                        Histogram.this.fTimeRangeStartText.setText(HistogramUtils.nanosecondsToString(Histogram.this.fDataModel.getStartTime()));
                        Histogram.this.fTimeRangeEndText.setText(HistogramUtils.nanosecondsToString(Histogram.this.fDataModel.getEndTime()));
                        Histogram.this.fMaxNbEventsText.setText(Long.toString(Histogram.this.fScaledData.fMaxValue));
                        Histogram.this.fMaxNbEventsText.getParent().layout();
                    }
                }
            });
        }
    }

    private void updateCurrentEventTime() {
        long bucketStartTime = this.getTimestamp(this.fScaledData.fCurrentBucket);
        ((HistogramView)this.fParentView).updateCurrentEventTime(bucketStartTime);
    }

    public void paintControl(PaintEvent event) {
        int canvasWidth = this.fCanvas.getBounds().width;
        int canvasHeight = this.fCanvas.getBounds().height;
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            return;
        }
        Image image = (Image)this.fCanvas.getData("double-buffer-image");
        if (image == null || image.getBounds().width != canvasWidth || image.getBounds().height != canvasHeight) {
            image = new Image((Device)event.display, canvasWidth, canvasHeight);
            this.fCanvas.setData("double-buffer-image", (Object)image);
        }
        GC imageGC = new GC((Drawable)image);
        this.formatImage(imageGC, image);
        event.gc.drawImage(image, 0, 0);
        imageGC.dispose();
    }

    private void formatImage(GC imageGC, Image image) {
        if (this.fScaledData == null) {
            return;
        }
        HistogramScaledData scaledData = new HistogramScaledData(this.fScaledData);
        try {
            int width = image.getBounds().width;
            int height = image.getBounds().height;
            imageGC.setBackground(this.fBackgroundColor);
            imageGC.fillRectangle(0, 0, image.getBounds().width + 1, image.getBounds().height + 1);
            imageGC.setBackground(this.fHistoBarColor);
            int limit = width < scaledData.fWidth ? width : scaledData.fWidth;
            int i = 1;
            while (i < limit) {
                int value = (int)((double)scaledData.fData[i] * scaledData.fScalingFactor);
                imageGC.fillRectangle(i, height - value, 1, value);
                ++i;
            }
            int currentBucket = scaledData.fCurrentBucket;
            if (currentBucket >= 0 && currentBucket < limit) {
                this.drawDelimiter(imageGC, this.fCurrentEventColor, height, currentBucket);
            }
            int lastEventIndex = limit - 1;
            while (lastEventIndex >= 0 && scaledData.fData[lastEventIndex] == 0) {
                --lastEventIndex;
            }
            this.drawDelimiter(imageGC, this.fLastEventColor, height, lastEventIndex += lastEventIndex < limit - 1 ? 1 : 0);
        }
        catch (Exception exception) {}
    }

    private void drawDelimiter(GC imageGC, Color color, int height, int index) {
        imageGC.setBackground(color);
        int dash = height / 4;
        imageGC.fillRectangle(index, 0 * dash, 1, dash - 1);
        imageGC.fillRectangle(index, 1 * dash, 1, dash - 1);
        imageGC.fillRectangle(index, 2 * dash, 1, dash - 1);
        imageGC.fillRectangle(index, 3 * dash, 1, height - 3 * dash);
    }

    public void keyPressed(KeyEvent event) {
        this.moveCursor(event.keyCode);
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (this.fDataModel.getNbEvents() > 0L && this.fScaledData.fLastBucket >= event.x) {
            this.fScaledData.fCurrentBucket = event.x;
            this.updateCurrentEventTime();
        }
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseHover(MouseEvent event) {
        if (this.fDataModel.getNbEvents() > 0L && this.fScaledData != null && this.fScaledData.fLastBucket >= event.x) {
            String tooltip = this.formatToolTipLabel(event.x);
            this.fCanvas.setToolTipText(tooltip);
        }
    }

    private String formatToolTipLabel(int index) {
        long startTime = this.fDataModel.getStartTime() + (long)this.fScaledData.fCurrentBucket * this.fScaledData.fBucketDuration;
        long endTime = startTime + this.fScaledData.fBucketDuration;
        int nbEvents = index >= 0 ? this.fScaledData.fData[index] : 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Range = [");
        buffer.append(HistogramUtils.nanosecondsToString(startTime));
        buffer.append(",");
        buffer.append(HistogramUtils.nanosecondsToString(endTime));
        buffer.append(")\n");
        buffer.append("Event count = ");
        buffer.append(nbEvents);
        return buffer.toString();
    }

    public void controlMoved(ControlEvent event) {
        this.refresh();
    }

    public void controlResized(ControlEvent event) {
        this.refresh();
    }
}

