/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow.model;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.linuxtools.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.model.ProcessKey;

public class FlowProcessContainer
implements ItemContainer<TimeRangeEventProcess> {
    private final HashMap<ProcessKey, TimeRangeEventProcess> allProcesses = new HashMap();
    private static Integer uniqueId = 0;

    FlowProcessContainer() {
    }

    @Override
    public void addItem(TimeRangeEventProcess newItem) {
        if (newItem != null) {
            this.allProcesses.put(new ProcessKey(newItem), newItem);
        }
    }

    @Override
    public Integer getUniqueId() {
        Integer n = uniqueId;
        uniqueId = n + 1;
        return n;
    }

    public TimeRangeEventProcess[] readItems() {
        return this.allProcesses.values().toArray(new TimeRangeEventProcess[this.allProcesses.size()]);
    }

    @Override
    public void clearChildren() {
        TimeRangeEventProcess process = null;
        Iterator<ProcessKey> iterator = this.allProcesses.keySet().iterator();
        while (iterator.hasNext()) {
            process = this.allProcesses.get(iterator.next());
            process.reset();
        }
    }

    @Override
    public void clearItems() {
        this.allProcesses.clear();
    }

    @Override
    public void removeItems(String traceId) {
        ProcessKey iterKey2 = null;
        for (ProcessKey iterKey2 : this.allProcesses.keySet()) {
            if (!this.allProcesses.get(iterKey2).getTraceID().equals(traceId)) continue;
            this.allProcesses.remove(iterKey2);
        }
    }

    public TimeRangeEventProcess findProcess(Long searchedPid, Long searchedCpuId, String searchedTraceID, Long searchedCreationtime) {
        TimeRangeEventProcess foundProcess = this.allProcesses.get(new ProcessKey(searchedPid, searchedCpuId, searchedTraceID, searchedCreationtime));
        return foundProcess;
    }
}

