/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.model.config;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceChannel;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.wizards.KernelTraceChannelConfigurationPage;
import org.eclipse.swt.widgets.TableItem;

public class TraceChannelCellModifier
implements ICellModifier {
    KernelTraceChannelConfigurationPage fConfigPage;

    public TraceChannelCellModifier(KernelTraceChannelConfigurationPage configPage) {
        this.fConfigPage = configPage;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.fConfigPage.getColumnProperties().indexOf(property);
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.fConfigPage.getTraceState() != TraceResource.TraceState.CREATED && this.fConfigPage.getTraceState() != TraceResource.TraceState.CONFIGURED) break;
                return true;
            }
            case 5: {
                if (!this.fConfigPage.isLocalTrace() || this.fConfigPage.getTraceState() != TraceResource.TraceState.CREATED && this.fConfigPage.getTraceState() != TraceResource.TraceState.CONFIGURED) break;
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.fConfigPage.getColumnProperties().indexOf(property);
        Object result = null;
        TraceChannel chan = (TraceChannel)element;
        switch (columnIndex) {
            case 0: {
                result = chan.getName();
                break;
            }
            case 1: {
                result = chan.isEnabled();
                break;
            }
            case 2: {
                result = chan.isChannelOverride();
                break;
            }
            case 3: {
                result = String.valueOf(chan.getSubbufNum());
                break;
            }
            case 4: {
                result = String.valueOf(chan.getSubbufSize());
                break;
            }
            case 5: {
                result = String.valueOf(chan.getTimer());
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.fConfigPage.getColumnProperties().indexOf(property);
        TableItem item = (TableItem)element;
        TraceChannel chan = (TraceChannel)item.getData();
        switch (columnIndex) {
            case 0: {
                chan.setName(((String)value).trim());
                break;
            }
            case 1: {
                chan.setIsEnabled(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                chan.setIsChannelOverride(((Boolean)value).booleanValue());
                break;
            }
            case 3: {
                String valueString = ((String)value).trim();
                if (valueString.length() == 0) {
                    valueString = "0";
                    break;
                }
                if ("?".equals(valueString)) {
                    chan.setSubbufNum(-1L);
                    break;
                }
                chan.setSubbufNum((long)Integer.parseInt(valueString));
                break;
            }
            case 4: {
                String valueString = ((String)value).trim();
                if (valueString.length() == 0) {
                    valueString = "0";
                    break;
                }
                if ("?".equals(valueString)) {
                    chan.setSubbufSize(-1L);
                    break;
                }
                chan.setSubbufSize((long)Integer.parseInt(valueString));
                break;
            }
            case 5: {
                String valueString = ((String)value).trim();
                if (valueString.length() == 0) {
                    valueString = "0";
                    break;
                }
                if ("?".equals(valueString)) {
                    chan.setTimer(-1L);
                    break;
                }
                chan.setTimer((long)Integer.parseInt(valueString));
            }
        }
        this.fConfigPage.refresh();
    }
}

