/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindStackFrame;
import org.eclipse.linuxtools.internal.valgrind.ui.CollapseAction;
import org.eclipse.linuxtools.internal.valgrind.ui.ExpandAction;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CoreMessagesViewer {
    public IDoubleClickListener doubleClickListener;
    public ITreeContentProvider contentProvider;
    public IAction expandAction;
    public IAction collapseAction;
    private TreeViewer viewer;

    public CoreMessagesViewer(Composite parent, int style) {
        this.viewer = new TreeViewer(parent, 0x304 | style);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Object[]) {
                    return (Object[])parentElement;
                }
                return ((IValgrindMessage)parentElement).getChildren();
            }

            public Object getParent(Object element) {
                return ((IValgrindMessage)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IValgrindMessage)element).getText();
            }

            public Image getImage(Object element) {
                Image image = element instanceof ValgrindStackFrame ? DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                return image;
            }
        });
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((TreeSelection)event.getSelection()).getFirstElement();
                if (element instanceof ValgrindStackFrame) {
                    ILaunchConfiguration config;
                    AbstractSourceLookupDirector director;
                    ISourceLookupParticipant[] participants;
                    ValgrindStackFrame frame = (ValgrindStackFrame)element;
                    ILaunch launch = frame.getLaunch();
                    ISourceLocator locator = launch.getSourceLocator();
                    if (locator instanceof AbstractSourceLookupDirector && (participants = (director = (AbstractSourceLookupDirector)locator).getParticipants()).length == 0 && (config = launch.getLaunchConfiguration()) != null) {
                        try {
                            IPersistableSourceLocator sourceLocator;
                            String id = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                            if (id == null) {
                                sourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                                sourceLocator.initializeDefaults(config);
                            } else {
                                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                                String memento = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                                if (memento == null) {
                                    sourceLocator.initializeDefaults(config);
                                } else {
                                    sourceLocator.initializeFromMemento(memento);
                                }
                            }
                            locator = sourceLocator;
                            launch.setSourceLocator((ISourceLocator)sourceLocator);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ISourceLookupResult result = DebugUITools.lookupSource((Object)frame.getFile(), (ISourceLocator)locator);
                    try {
                        ProfileUIUtils.openEditorAndSelect((ISourceLookupResult)result, (int)frame.getLine());
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else if (CoreMessagesViewer.this.viewer.getExpandedState(element)) {
                    CoreMessagesViewer.this.viewer.collapseToLevel(element, -1);
                } else {
                    CoreMessagesViewer.this.viewer.expandToLevel(element, 1);
                }
            }
        };
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        this.expandAction = new ExpandAction(this.viewer);
        this.collapseAction = new CollapseAction(this.viewer);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITreeSelection selection = (ITreeSelection)CoreMessagesViewer.this.viewer.getSelection();
                Object element = selection.getFirstElement();
                if (CoreMessagesViewer.this.contentProvider.hasChildren(element)) {
                    manager.add(CoreMessagesViewer.this.expandAction);
                    manager.add(CoreMessagesViewer.this.collapseAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        Menu contextMenu = manager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getControl().setMenu(contextMenu);
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }
}

