/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.birt;

import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.CallBackValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.birt.Messages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class HeapChart
extends ChartWithAxesImpl {
    private static String[] byteUnits = new String[]{Messages.getString("HeapChart.B"), Messages.getString("HeapChart.KiB"), Messages.getString("HeapChart.MiB"), Messages.getString("HeapChart.GiB"), Messages.getString("HeapChart.TiB")};
    private static String[] instrUnits = new String[]{Messages.getString("HeapChart.i"), Messages.getString("HeapChart.Ki"), Messages.getString("HeapChart.Mi"), Messages.getString("HeapChart.Gi"), Messages.getString("HeapChart.Ti")};
    private static String[] secondUnits = new String[]{Messages.getString("HeapChart.ms"), Messages.getString("HeapChart.s")};
    protected static final int BYTE_MULT = 1024;
    protected static final int BYTE_LIMIT = byteUnits.length - 1;
    protected static final int INSTR_MULT = 1000;
    protected static final int INSTR_LIMIT = instrUnits.length - 1;
    protected static final int MS_MULT = 1000;
    protected static final int MS_LIMIT = secondUnits.length - 1;
    protected static final int SCALING_THRESHOLD = 20;
    protected String xUnits;
    protected String yUnits;

    public HeapChart(MassifSnapshot[] snapshots) {
        MassifSnapshot.TimeUnit timeUnit = snapshots[0].getUnit();
        long xScaling = this.getXScaling(snapshots, timeUnit);
        long yScaling = this.getYScaling(snapshots);
        double[] time = new double[snapshots.length];
        double[] dataUseful = new double[snapshots.length];
        double[] dataExtra = new double[snapshots.length];
        double[] dataStacks = null;
        boolean isStack = this.isStackProfiled(snapshots);
        if (isStack) {
            dataStacks = new double[snapshots.length];
        }
        double[] dataTotal = new double[snapshots.length];
        int i = 0;
        while (i < snapshots.length) {
            time[i] = snapshots[i].getTime() / xScaling;
            dataUseful[i] = snapshots[i].getHeapBytes() / yScaling;
            dataExtra[i] = snapshots[i].getHeapExtra() / yScaling;
            dataTotal[i] = dataUseful[i] + dataExtra[i];
            if (isStack) {
                dataStacks[i] = snapshots[i].getStacks() / yScaling;
            }
            ++i;
        }
        this.initialize();
        this.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        this.setType("Line Chart");
        this.setSubType("Overlay");
        Font font = JFaceResources.getDialogFont();
        FontData fd = font.getFontData()[0];
        FontDefinition titleFont = this.getTitle().getLabel().getCaption().getFont();
        titleFont.setName(fd.getName());
        titleFont.setSize((float)(fd.getHeight() + 2));
        this.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = this.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        Axis xAxisPrimary = this.getPrimaryBaseAxes()[0];
        xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        xAxisPrimary.getTitle().getCaption().setValue(this.xUnits);
        xAxisPrimary.getTitle().setVisible(true);
        FontDefinition xAxisFont = xAxisPrimary.getTitle().getCaption().getFont();
        xAxisFont.setName(fd.getName());
        xAxisFont.setSize((float)fd.getHeight());
        xAxisFont = xAxisPrimary.getLabel().getCaption().getFont();
        xAxisFont.setName(fd.getName());
        xAxisFont.setSize((float)fd.getHeight());
        Axis yAxisPrimary = this.getPrimaryOrthogonalAxis(xAxisPrimary);
        yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxisPrimary.getMajorGrid().getLineAttributes().setVisible(true);
        yAxisPrimary.getTitle().getCaption().setValue(this.yUnits);
        yAxisPrimary.getTitle().setVisible(true);
        FontDefinition yAxisFont = yAxisPrimary.getTitle().getCaption().getFont();
        yAxisFont.setName(fd.getName());
        yAxisFont.setSize((float)fd.getHeight());
        yAxisFont = yAxisPrimary.getLabel().getCaption().getFont();
        yAxisFont.setName(fd.getName());
        yAxisFont.setSize((float)fd.getHeight());
        Legend legend = this.getLegend();
        legend.setPosition(Position.BELOW_LITERAL);
        legend.setOrientation(Orientation.HORIZONTAL_LITERAL);
        FontDefinition legendFont = legend.getText().getFont();
        legendFont.setName(fd.getName());
        legendFont.setSize((float)fd.getHeight());
        NumberDataSet mainValues = NumberDataSetImpl.create((Object)time);
        NumberDataSet orthoValues1 = NumberDataSetImpl.create((Object)dataUseful);
        NumberDataSet orthoValues2 = NumberDataSetImpl.create((Object)dataExtra);
        NumberDataSet orthoValuesS = null;
        if (isStack) {
            orthoValuesS = NumberDataSetImpl.create((Object)dataStacks);
        }
        NumberDataSet orthoValues3 = NumberDataSetImpl.create((Object)dataTotal);
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData sdOrthogonal1 = DataFactory.eINSTANCE.createOrthogonalSampleData();
        sdOrthogonal1.setDataSetRepresentation("");
        sdOrthogonal1.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)sdOrthogonal1);
        OrthogonalSampleData sdOrthogonal2 = DataFactory.eINSTANCE.createOrthogonalSampleData();
        sdOrthogonal2.setDataSetRepresentation("");
        sdOrthogonal2.setSeriesDefinitionIndex(1);
        sd.getOrthogonalSampleData().add((Object)sdOrthogonal2);
        if (isStack) {
            OrthogonalSampleData sdOrthogonalS = DataFactory.eINSTANCE.createOrthogonalSampleData();
            sdOrthogonalS.setDataSetRepresentation("");
            sdOrthogonalS.setSeriesDefinitionIndex(2);
            sd.getOrthogonalSampleData().add((Object)sdOrthogonalS);
        }
        OrthogonalSampleData sdOrthogonal3 = DataFactory.eINSTANCE.createOrthogonalSampleData();
        sdOrthogonal3.setDataSetRepresentation("");
        sdOrthogonal3.setSeriesDefinitionIndex(isStack ? 3 : 2);
        sd.getOrthogonalSampleData().add((Object)sdOrthogonal3);
        this.setSampleData(sd);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)mainValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        LineSeries ls1 = (LineSeries)LineSeriesImpl.create();
        ls1.setDataSet((DataSet)orthoValues1);
        ls1.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
        int i2 = 0;
        while (i2 < ls1.getMarkers().size()) {
            Marker marker = (Marker)ls1.getMarkers().get(i2);
            marker.setType(MarkerType.DIAMOND_LITERAL);
            ++i2;
        }
        ls1.setPaletteLineColor(true);
        ls1.setSeriesIdentifier((Object)Messages.getString("HeapChart.Useful_Heap"));
        ls1.getTriggers().add((Object)this.getClickTrigger(ls1));
        ls1.getTriggers().add((Object)this.getDblClickTrigger(ls1));
        LineSeries ls2 = (LineSeries)LineSeriesImpl.create();
        ls2.setDataSet((DataSet)orthoValues2);
        ls2.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
        int i3 = 0;
        while (i3 < ls2.getMarkers().size()) {
            Marker marker = (Marker)ls2.getMarkers().get(i3);
            marker.setType(MarkerType.DIAMOND_LITERAL);
            ++i3;
        }
        ls2.setPaletteLineColor(true);
        ls2.setSeriesIdentifier((Object)Messages.getString("HeapChart.Extra_Heap"));
        ls2.getTriggers().add((Object)this.getClickTrigger(ls2));
        ls2.getTriggers().add((Object)this.getDblClickTrigger(ls2));
        LineSeries lsS = null;
        if (isStack) {
            lsS = (LineSeries)LineSeriesImpl.create();
            lsS.setDataSet((DataSet)orthoValuesS);
            lsS.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
            int i4 = 0;
            while (i4 < lsS.getMarkers().size()) {
                Marker marker = (Marker)lsS.getMarkers().get(i4);
                marker.setType(MarkerType.DIAMOND_LITERAL);
                ++i4;
            }
            lsS.setPaletteLineColor(true);
            lsS.setSeriesIdentifier((Object)Messages.getString("HeapChart.Stacks"));
            lsS.getTriggers().add((Object)this.getClickTrigger(lsS));
            lsS.getTriggers().add((Object)this.getDblClickTrigger(lsS));
        }
        LineSeries ls3 = (LineSeries)LineSeriesImpl.create();
        ls3.setDataSet((DataSet)orthoValues3);
        ls3.getLineAttributes().setColor(ColorDefinitionImpl.CREAM());
        int i5 = 0;
        while (i5 < ls3.getMarkers().size()) {
            Marker marker = (Marker)ls3.getMarkers().get(i5);
            marker.setType(MarkerType.DIAMOND_LITERAL);
            ++i5;
        }
        ls3.setPaletteLineColor(true);
        ls3.setSeriesIdentifier((Object)Messages.getString("HeapChart.Total_Heap"));
        ls3.getTriggers().add((Object)this.getClickTrigger(ls3));
        ls3.getTriggers().add((Object)this.getDblClickTrigger(ls3));
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(-1);
        yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeries().add((Object)ls1);
        sdY.getSeries().add((Object)ls2);
        if (isStack) {
            sdY.getSeries().add((Object)lsS);
        }
        sdY.getSeries().add((Object)ls3);
    }

    private Trigger getClickTrigger(LineSeries ls) {
        return TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf(ls.getSeriesIdentifier()))));
    }

    private Trigger getDblClickTrigger(LineSeries ls) {
        return TriggerImpl.create((TriggerCondition)TriggerCondition.ONDBLCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf(ls.getSeriesIdentifier()))));
    }

    private boolean isStackProfiled(MassifSnapshot[] snapshots) {
        return HeapChart.getMaxStack(snapshots) > 0L;
    }

    private long getYScaling(MassifSnapshot[] snapshots) {
        long max = HeapChart.getMaxValue(snapshots);
        int count = 0;
        while (max > 20480L && count < BYTE_LIMIT) {
            max /= 1024L;
            ++count;
        }
        this.yUnits = byteUnits[count];
        return (long)Math.pow(1024.0, count);
    }

    private long getXScaling(MassifSnapshot[] snapshots, MassifSnapshot.TimeUnit unit) {
        String[] units;
        int limit;
        int mult;
        long max = snapshots[snapshots.length - 1].getTime();
        switch (unit) {
            case BYTES: {
                mult = 1024;
                limit = BYTE_LIMIT;
                units = byteUnits;
                break;
            }
            case INSTRUCTIONS: {
                mult = 1000;
                limit = INSTR_LIMIT;
                units = instrUnits;
                break;
            }
            default: {
                mult = 1000;
                limit = MS_LIMIT;
                units = secondUnits;
            }
        }
        int count = 0;
        while (max > (long)(mult * 20) && count < limit) {
            max /= (long)mult;
            ++count;
        }
        this.xUnits = units[count];
        return (long)Math.pow(mult, count);
    }

    private static long getMaxValue(MassifSnapshot[] snapshots) {
        long max = 0L;
        MassifSnapshot[] massifSnapshotArray = snapshots;
        int n = snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot snapshot = massifSnapshotArray[n2];
            if (snapshot.getTotal() > max) {
                max = snapshot.getTotal();
            }
            ++n2;
        }
        return max;
    }

    private static long getMaxStack(MassifSnapshot[] snapshots) {
        long max = 0L;
        MassifSnapshot[] massifSnapshotArray = snapshots;
        int n = snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            MassifSnapshot snapshot = massifSnapshotArray[n2];
            if (snapshot.getTotal() > max) {
                max = snapshot.getStacks();
            }
            ++n2;
        }
        return max;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public String getYUnits() {
        return this.yUnits;
    }

    public static String[] getByteUnits() {
        return byteUnits;
    }

    public static String[] getInstrUnits() {
        return instrUnits;
    }

    public static String[] getSecondUnits() {
        return secondUnits;
    }
}

