/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.osgi.framework.Version;

public class CachegrindToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    public static final String CACHEGRIND = "cachegrind";
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.cachegrind";
    protected Button cacheButton;
    protected Button branchButton;
    protected Composite i1Top;
    protected Spinner i1SizeSpinner;
    protected Spinner i1AssocSpinner;
    protected Spinner i1LineSizeSpinner;
    protected Button i1Button;
    protected Composite d1Top;
    protected Spinner d1SizeSpinner;
    protected Spinner d1AssocSpinner;
    protected Spinner d1LineSizeSpinner;
    protected Button d1Button;
    protected Composite l2Top;
    protected Spinner l2SizeSpinner;
    protected Spinner l2AssocSpinner;
    protected Spinner l2LineSizeSpinner;
    protected Button l2Button;
    protected boolean isInitializing = false;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CachegrindToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CachegrindToolPage.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(768));
        this.cacheButton = new Button(top, 32);
        this.cacheButton.setText(Messages.getString("CachegrindToolPage.Profile_Cache"));
        this.cacheButton.addSelectionListener(this.selectListener);
        this.branchButton = new Button(top, 32);
        this.branchButton.setText(Messages.getString("CachegrindToolPage.Profile_Branch"));
        this.branchButton.addSelectionListener(this.selectListener);
        this.createVerticalSpacer(top, 1);
        Group cacheGroup = new Group(top, 8);
        cacheGroup.setLayout((Layout)new GridLayout(2, false));
        cacheGroup.setText(Messages.getString("CachegrindToolPage.Manually_Set_Cache"));
        this.i1Button = new Button((Composite)cacheGroup, 32);
        this.i1Button.setText(Messages.getString("CachegrindToolPage.I1_Cache"));
        this.i1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CachegrindToolPage.this.checkI1Enablement();
                CachegrindToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.i1Top = new Composite((Composite)cacheGroup, 2048);
        GridLayout i1Layout = new GridLayout(6, false);
        i1Layout.horizontalSpacing = 10;
        this.i1Top.setLayout((Layout)i1Layout);
        Label i1SizeLabel = new Label(this.i1Top, 0);
        i1SizeLabel.setText(Messages.getString("CachegrindToolPage.Size"));
        this.i1SizeSpinner = new Spinner(this.i1Top, 2048);
        this.i1SizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.i1SizeSpinner.addModifyListener(this.modifyListener);
        Label i1AssocLabel = new Label(this.i1Top, 0);
        i1AssocLabel.setText(Messages.getString("CachegrindToolPage.Assoc"));
        this.i1AssocSpinner = new Spinner(this.i1Top, 2048);
        this.i1AssocSpinner.setMaximum(Integer.MAX_VALUE);
        this.i1AssocSpinner.addModifyListener(this.modifyListener);
        Label i1LineSizeLabel = new Label(this.i1Top, 0);
        i1LineSizeLabel.setText(Messages.getString("CachegrindToolPage.Line_Size"));
        this.i1LineSizeSpinner = new Spinner(this.i1Top, 2048);
        this.i1LineSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.i1LineSizeSpinner.addModifyListener(this.modifyListener);
        this.d1Button = new Button((Composite)cacheGroup, 32);
        this.d1Button.setText(Messages.getString("CachegrindToolPage.D1_Cache"));
        this.d1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CachegrindToolPage.this.checkD1Enablement();
                CachegrindToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.d1Top = new Composite((Composite)cacheGroup, 2048);
        GridLayout d1Layout = new GridLayout(6, false);
        d1Layout.horizontalSpacing = 10;
        this.d1Top.setLayout((Layout)d1Layout);
        Label d1SizeLabel = new Label(this.d1Top, 0);
        d1SizeLabel.setText(Messages.getString("CachegrindToolPage.Size"));
        this.d1SizeSpinner = new Spinner(this.d1Top, 2048);
        this.d1SizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.d1SizeSpinner.addModifyListener(this.modifyListener);
        Label d1AssocLabel = new Label(this.d1Top, 0);
        d1AssocLabel.setText(Messages.getString("CachegrindToolPage.Assoc"));
        this.d1AssocSpinner = new Spinner(this.d1Top, 2048);
        this.d1AssocSpinner.setMaximum(Integer.MAX_VALUE);
        this.d1AssocSpinner.addModifyListener(this.modifyListener);
        Label d1LineSizeLabel = new Label(this.d1Top, 0);
        d1LineSizeLabel.setText(Messages.getString("CachegrindToolPage.Line_Size"));
        this.d1LineSizeSpinner = new Spinner(this.d1Top, 2048);
        this.d1LineSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.d1LineSizeSpinner.addModifyListener(this.modifyListener);
        this.l2Button = new Button((Composite)cacheGroup, 32);
        this.l2Button.setText(Messages.getString("CachegrindToolPage.L2_Cache"));
        this.l2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CachegrindToolPage.this.checkL2Enablement();
                CachegrindToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.l2Top = new Composite((Composite)cacheGroup, 2048);
        GridLayout l2Layout = new GridLayout(6, false);
        l2Layout.horizontalSpacing = 10;
        this.l2Top.setLayout((Layout)l2Layout);
        Label l2SizeLabel = new Label(this.l2Top, 0);
        l2SizeLabel.setText(Messages.getString("CachegrindToolPage.Size"));
        this.l2SizeSpinner = new Spinner(this.l2Top, 2048);
        this.l2SizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.l2SizeSpinner.addModifyListener(this.modifyListener);
        Label l2AssocLabel = new Label(this.l2Top, 0);
        l2AssocLabel.setText(Messages.getString("CachegrindToolPage.Assoc"));
        this.l2AssocSpinner = new Spinner(this.l2Top, 2048);
        this.l2AssocSpinner.setMaximum(Integer.MAX_VALUE);
        this.l2AssocSpinner.addModifyListener(this.modifyListener);
        Label l2LineSizeLabel = new Label(this.l2Top, 0);
        l2LineSizeLabel.setText(Messages.getString("CachegrindToolPage.Line_Size"));
        this.l2LineSizeSpinner = new Spinner(this.l2Top, 2048);
        this.l2LineSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.l2LineSizeSpinner.addModifyListener(this.modifyListener);
    }

    public String getName() {
        return Messages.getString("CachegrindToolPage.Cachegrind_Options");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.cacheButton.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.CACHE_SIM", true));
            this.branchButton.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.BRANCH_SIM", false));
            this.i1Button.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1", false));
            this.i1SizeSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_SIZE", 0));
            this.i1AssocSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_ASSOC", 0));
            this.i1LineSizeSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_LSIZE", 0));
            this.checkI1Enablement();
            this.d1Button.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1", false));
            this.d1SizeSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_SIZE", 0));
            this.d1AssocSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_ASSOC", 0));
            this.d1LineSizeSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_LSIZE", 0));
            this.checkD1Enablement();
            this.l2Button.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2", false));
            this.l2SizeSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_SIZE", 0));
            this.l2AssocSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_ASSOC", 0));
            this.l2LineSizeSpinner.setSelection(config.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_LSIZE", 0));
            this.checkL2Enablement();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.CACHE_SIM", this.cacheButton.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.BRANCH_SIM", this.branchButton.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1", this.i1Button.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_SIZE", this.i1SizeSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_ASSOC", this.i1AssocSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_LSIZE", this.i1LineSizeSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1", this.d1Button.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_SIZE", this.d1SizeSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_ASSOC", this.d1AssocSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_LSIZE", this.d1LineSizeSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2", this.l2Button.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_SIZE", this.l2SizeSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_ASSOC", this.l2AssocSpinner.getSelection());
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_LSIZE", this.l2LineSizeSpinner.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.CACHE_SIM", true);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.BRANCH_SIM", false);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1", false);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_SIZE", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_ASSOC", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.I1_LSIZE", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1", false);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_SIZE", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_ASSOC", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.D1_LSIZE", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2", false);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_SIZE", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_ASSOC", 0);
        config.setAttribute("org.eclipse.linuxtools.valgrind.cachegrind.L2_LSIZE", 0);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean result = false;
        try {
            result = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.CACHE_SIM", true) || launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.cachegrind.BRANCH_SIM", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!result) {
            this.setErrorMessage(Messages.getString("CachegrindToolPage.At_least_one_of"));
        }
        return result;
    }

    public void setValgrindVersion(Version ver) {
    }

    protected void createHorizontalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numlines;
        lbl.setLayoutData((Object)gd);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    protected void checkI1Enablement() {
        boolean checked = this.i1Button.getSelection();
        this.i1SizeSpinner.setEnabled(checked);
        this.i1AssocSpinner.setEnabled(checked);
        this.i1LineSizeSpinner.setEnabled(checked);
    }

    protected void checkD1Enablement() {
        boolean checked = this.d1Button.getSelection();
        this.d1SizeSpinner.setEnabled(checked);
        this.d1AssocSpinner.setEnabled(checked);
        this.d1LineSizeSpinner.setEnabled(checked);
    }

    protected void checkL2Enablement() {
        boolean checked = this.l2Button.getSelection();
        this.l2SizeSpinner.setEnabled(checked);
        this.l2AssocSpinner.setEnabled(checked);
        this.l2LineSizeSpinner.setEnabled(checked);
    }

    public Button getCacheButton() {
        return this.cacheButton;
    }

    public Button getBranchButton() {
        return this.branchButton;
    }

    public Spinner getI1SizeSpinner() {
        return this.i1SizeSpinner;
    }

    public Spinner getI1AssocSpinner() {
        return this.i1AssocSpinner;
    }

    public Spinner getI1LineSizeSpinner() {
        return this.i1LineSizeSpinner;
    }

    public Button getI1Button() {
        return this.i1Button;
    }

    public Spinner getD1SizeSpinner() {
        return this.d1SizeSpinner;
    }

    public Spinner getD1AssocSpinner() {
        return this.d1AssocSpinner;
    }

    public Spinner getD1LineSizeSpinner() {
        return this.d1LineSizeSpinner;
    }

    public Button getD1Button() {
        return this.d1Button;
    }

    public Spinner getL2SizeSpinner() {
        return this.l2SizeSpinner;
    }

    public Spinner getL2AssocSpinner() {
        return this.l2AssocSpinner;
    }

    public Spinner getL2LineSizeSpinner() {
        return this.l2LineSizeSpinner;
    }

    public Button getL2Button() {
        return this.l2Button;
    }
}

