/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.filter.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.linuxtools.tmf.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterAndNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterCompareNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterContainsNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterEqualsNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterEventTypeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterMatchesNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterOrNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TmfFilterXMLWriter {
    private Document document = null;

    public TmfFilterXMLWriter(ITmfFilterTreeNode root) throws IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        Element rootElement = this.document.createElement(root.getNodeName());
        this.document.appendChild(rootElement);
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = root.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            TmfFilterXMLWriter.buildXMLTree(this.document, node, rootElement);
            ++n2;
        }
    }

    public static void buildXMLTree(Document document, ITmfFilterTreeNode treenode, Element parentElement) {
        TmfFilterTreeNode node;
        Element element = document.createElement(treenode.getNodeName());
        if (treenode instanceof TmfFilterNode) {
            node = (TmfFilterNode)treenode;
            element.setAttribute("name", ((TmfFilterNode)node).getFilterName());
        } else if (treenode instanceof TmfFilterEventTypeNode) {
            node = (TmfFilterEventTypeNode)treenode;
            element.setAttribute("type", ((TmfFilterEventTypeNode)node).getEventType());
            element.setAttribute("name", ((TmfFilterEventTypeNode)node).getName());
        } else if (treenode instanceof TmfFilterAndNode) {
            node = (TmfFilterAndNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterAndNode)node).isNot()));
        } else if (treenode instanceof TmfFilterOrNode) {
            node = (TmfFilterOrNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterOrNode)node).isNot()));
        } else if (treenode instanceof TmfFilterContainsNode) {
            node = (TmfFilterContainsNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterContainsNode)node).isNot()));
            element.setAttribute("field", ((TmfFilterContainsNode)node).getField());
            element.setAttribute("value", ((TmfFilterContainsNode)node).getValue());
            element.setAttribute("ignorecase", Boolean.toString(((TmfFilterContainsNode)node).isIgnoreCase()));
        } else if (treenode instanceof TmfFilterEqualsNode) {
            node = (TmfFilterEqualsNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterEqualsNode)node).isNot()));
            element.setAttribute("field", ((TmfFilterEqualsNode)node).getField());
            element.setAttribute("value", ((TmfFilterEqualsNode)node).getValue());
            element.setAttribute("ignorecase", Boolean.toString(((TmfFilterEqualsNode)node).isIgnoreCase()));
        } else if (treenode instanceof TmfFilterMatchesNode) {
            node = (TmfFilterMatchesNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterMatchesNode)node).isNot()));
            element.setAttribute("field", ((TmfFilterMatchesNode)node).getField());
            element.setAttribute("regex", ((TmfFilterMatchesNode)node).getRegex());
        } else if (treenode instanceof TmfFilterCompareNode) {
            node = (TmfFilterCompareNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterCompareNode)node).isNot()));
            element.setAttribute("field", ((TmfFilterCompareNode)node).getField());
            element.setAttribute("result", Integer.toString(((TmfFilterCompareNode)node).getResult()));
            element.setAttribute("type", ((TmfFilterCompareNode)node).getType().toString());
            element.setAttribute("value", ((TmfFilterCompareNode)node).getValue());
        }
        parentElement.appendChild(element);
        int i = 0;
        while (i < treenode.getChildrenCount()) {
            TmfFilterXMLWriter.buildXMLTree(document, treenode.getChild(i), element);
            ++i;
        }
    }

    public void saveTree(String uri) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(new File(uri));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

