/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.experiment;

import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.tmf.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperimentContext;
import org.eclipse.linuxtools.tmf.experiment.TmfExperimentLocation;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.trace.TmfContext;

public class TmfExperiment<T extends TmfEvent>
extends TmfEventProvider<T>
implements ITmfTrace {
    protected static TmfExperiment<?> fCurrentExperiment = null;
    protected ITmfTrace[] fTraces;
    protected long fNbEvents;
    protected TmfTimeRange fTimeRange;
    protected TmfTimestamp fEpoch;
    protected Vector<TmfCheckpoint> fCheckpoints = new Vector();
    protected TmfExperimentContext fExperimentContext;
    private static final int DEFAULT_INDEX_PAGE_SIZE = 5000;
    protected int fIndexPageSize;

    public TmfExperiment(Class<T> type, String id, ITmfTrace[] traces, TmfTimestamp epoch, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.Zero, indexPageSize, false);
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace[] traces, TmfTimestamp epoch, int indexPageSize, boolean preIndexExperiment) {
        super(id, type);
        this.fTraces = traces;
        this.fEpoch = epoch;
        this.fIndexPageSize = indexPageSize;
        if (preIndexExperiment) {
            this.indexExperiment(true);
        }
        this.updateTimeRange();
    }

    protected TmfExperiment(String id, Class<T> type) {
        super(id, type);
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace[] traces) {
        this(type, id, traces, TmfTimestamp.Zero, 5000);
    }

    public TmfExperiment(Class<T> type, String id, ITmfTrace[] traces, int indexPageSize) {
        this(type, id, traces, TmfTimestamp.Zero, indexPageSize);
    }

    public TmfExperiment(TmfExperiment<T> other) {
        super(String.valueOf(other.getName()) + "(clone)", other.fType);
        this.fEpoch = other.fEpoch;
        this.fIndexPageSize = other.fIndexPageSize;
        this.fTraces = new ITmfTrace[other.fTraces.length];
        int trace = 0;
        while (trace < other.fTraces.length) {
            this.fTraces[trace] = other.fTraces[trace].createTraceCopy();
            ++trace;
        }
        this.fNbEvents = other.fNbEvents;
        this.fTimeRange = other.fTimeRange;
    }

    @Override
    public TmfExperiment<T> createTraceCopy() {
        TmfExperiment<T> experiment = new TmfExperiment<T>(this);
        TmfSignalManager.deregister(experiment);
        return experiment;
    }

    @Override
    public synchronized void dispose() {
        TmfExperimentDisposedSignal signal = new TmfExperimentDisposedSignal((Object)this, this);
        this.broadcast(signal);
        if (this.fTraces != null) {
            ITmfTrace[] iTmfTraceArray = this.fTraces;
            int n = this.fTraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace trace = iTmfTraceArray[n2];
                trace.dispose();
                ++n2;
            }
            this.fTraces = null;
        }
        if (this.fCheckpoints != null) {
            this.fCheckpoints.clear();
        }
        super.dispose();
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public int getCacheSize() {
        return this.fIndexPageSize;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    @Override
    public TmfTimestamp getStartTime() {
        return this.fTimeRange.getStartTime();
    }

    @Override
    public TmfTimestamp getEndTime() {
        return this.fTimeRange.getEndTime();
    }

    public Vector<TmfCheckpoint> getCheckpoints() {
        return this.fCheckpoints;
    }

    public static void setCurrentExperiment(TmfExperiment<?> experiment) {
        fCurrentExperiment = experiment;
    }

    public static TmfExperiment<?> getCurrentExperiment() {
        return fCurrentExperiment;
    }

    public TmfTimestamp getEpoch() {
        return this.fEpoch;
    }

    public ITmfTrace[] getTraces() {
        return this.fTraces;
    }

    @Override
    public long getRank(TmfTimestamp timestamp) {
        TmfExperimentContext context = this.seekEvent(timestamp);
        return context.getRank();
    }

    public TmfTimestamp getTimestamp(int index) {
        TmfExperimentContext context = this.seekEvent(index);
        TmfEvent event = this.getNextEvent(context);
        return event != null ? event.getTimestamp() : null;
    }

    private void updateNbEvents() {
        int nbEvents = 0;
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            nbEvents = (int)((long)nbEvents + trace.getNbEvents());
            ++n2;
        }
        this.fNbEvents = nbEvents;
    }

    private void updateTimeRange() {
        TmfTimestamp startTime = this.fTimeRange != null ? this.fTimeRange.getStartTime() : TmfTimestamp.BigCrunch;
        TmfTimestamp endTime = this.fTimeRange != null ? this.fTimeRange.getEndTime() : TmfTimestamp.BigBang;
        ITmfTrace[] iTmfTraceArray = this.fTraces;
        int n = this.fTraces.length;
        int n2 = 0;
        while (n2 < n) {
            TmfTimestamp traceEndTime;
            ITmfTrace trace = iTmfTraceArray[n2];
            TmfTimestamp traceStartTime = trace.getStartTime();
            if (traceStartTime.compareTo(startTime, true) < 0) {
                startTime = traceStartTime;
            }
            if ((traceEndTime = trace.getEndTime()).compareTo(endTime, true) > 0) {
                endTime = traceEndTime;
            }
            ++n2;
        }
        this.fTimeRange = new TmfTimeRange(startTime, endTime);
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<T> request) {
        TmfTimestamp timestamp = request instanceof ITmfEventRequest ? ((ITmfEventRequest)request).getRange().getStartTime() : null;
        TmfExperimentContext context = null;
        context = timestamp != null ? this.seekEvent(timestamp) : (this.fExperimentContext != null && this.fExperimentContext.getRank() == (long)request.getIndex() ? this.fExperimentContext : this.seekEvent(request.getIndex()));
        return context;
    }

    @Override
    public T getNext(ITmfContext context) {
        if (context instanceof TmfExperimentContext) {
            return (T)this.getNextEvent((TmfExperimentContext)context);
        }
        return null;
    }

    @Override
    public synchronized TmfExperimentContext seekLocation(ITmfLocation<?> location) {
        if (location != null && !(location instanceof TmfExperimentLocation)) {
            return null;
        }
        TmfExperimentLocation expLocation = location == null ? new TmfExperimentLocation(new ITmfLocation[this.fTraces.length], new long[this.fTraces.length]) : (TmfExperimentLocation)location.clone();
        TmfExperimentContext context = new TmfExperimentContext(this.fTraces, new TmfContext[this.fTraces.length]);
        long rank = 0L;
        int i = 0;
        while (i < this.fTraces.length) {
            ITmfLocation traceLocation = ((ITmfLocation[])expLocation.getLocation())[i];
            long traceRank = expLocation.getRanks()[i];
            context.getContexts()[i] = this.fTraces[i].seekLocation(traceLocation);
            context.getContexts()[i].setRank(traceRank);
            rank += traceRank;
            ((ITmfLocation[])expLocation.getLocation())[i] = context.getContexts()[i].getLocation();
            context.getEvents()[i] = this.fTraces[i].getNextEvent(context.getContexts()[i]);
            ++i;
        }
        context.setLocation(expLocation);
        context.setLastTrace(-1);
        context.setRank(rank);
        this.fExperimentContext = context;
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TmfExperimentContext seekEvent(TmfTimestamp timestamp) {
        ITmfLocation<?> location;
        int index;
        if (timestamp == null) {
            timestamp = TmfTimestamp.BigBang;
        }
        if ((index = Collections.binarySearch(this.fCheckpoints, new TmfCheckpoint(timestamp, null))) < 0) {
            index = Math.max(0, -(index + 2));
        }
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() > 0) {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            } else {
                location = null;
            }
        }
        TmfContext context = this.seekLocation((ITmfLocation)location);
        context.setRank((long)index * (long)this.fIndexPageSize);
        TmfEvent event = this.parseEvent(context);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            this.getNextEvent(context);
            event = this.parseEvent(context);
        }
        if (event == null) {
            context.setLocation(null);
            context.setRank(-2L);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TmfExperimentContext seekEvent(long rank) {
        ITmfLocation<?> location;
        int index = (int)rank / this.fIndexPageSize;
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() == 0) {
                location = null;
            } else {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            }
        }
        TmfContext context = this.seekLocation((ITmfLocation)location);
        context.setRank((long)index * (long)this.fIndexPageSize);
        TmfEvent event = this.parseEvent(context);
        long pos = context.getRank();
        while (event != null && pos++ < rank) {
            this.getNextEvent(context);
            event = this.parseEvent(context);
        }
        if (event == null) {
            context.setLocation(null);
            context.setRank(-2L);
        }
        return context;
    }

    @Override
    public TmfContext seekLocation(double ratio) {
        TmfExperimentContext context = this.seekEvent((long)(ratio * (double)this.getNbEvents()));
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        if (location instanceof TmfExperimentLocation) {
            return (double)this.seekLocation((ITmfLocation)location).getRank() / (double)this.getNbEvents();
        }
        return 0.0;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        if (this.fExperimentContext != null) {
            return this.fExperimentContext.getLocation();
        }
        return null;
    }

    @Override
    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfEvent[] eventArray;
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.fExperimentContext = this.seekLocation((ITmfLocation)context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            TmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = expContext.getTraces()[lastTrace].getNextEvent(traceContext);
            expContext.setLastTrace(-1);
        }
        if ((eventArray = expContext.getEvents()) == null) {
            return null;
        }
        int trace = -1;
        TmfTimestamp timestamp = TmfTimestamp.BigCrunch;
        if (eventArray.length == 1) {
            if (eventArray[0] != null) {
                timestamp = eventArray[0].getTimestamp();
                trace = 0;
            }
        } else {
            int i = 0;
            while (i < eventArray.length) {
                TmfTimestamp otherTS;
                TmfEvent event = eventArray[i];
                if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                    trace = i;
                    timestamp = otherTS;
                }
                ++i;
            }
        }
        TmfEvent event = null;
        if (trace != -1) {
            this.updateIndex(expContext, timestamp);
            TmfContext traceContext = expContext.getContexts()[trace];
            TmfExperimentLocation expLocation = (TmfExperimentLocation)expContext.getLocation();
            ((ITmfLocation[])expLocation.getLocation())[trace] = traceContext.getLocation();
            expLocation.getRanks()[trace] = traceContext.getRank();
            expContext.setLastTrace(trace);
            expContext.updateRank(1);
            event = expContext.getEvents()[trace];
            this.fExperimentContext = expContext;
        }
        return event;
    }

    public synchronized void updateIndex(ITmfContext context, TmfTimestamp timestamp) {
        long rank = context.getRank();
        if (context.isValidRank() && rank % (long)this.fIndexPageSize == 0L) {
            long position = rank / (long)this.fIndexPageSize;
            if ((long)this.fCheckpoints.size() == position) {
                ITmfLocation<?> location = context.getLocation().clone();
                this.fCheckpoints.add(new TmfCheckpoint(timestamp.clone(), location));
            }
        }
    }

    @Override
    public TmfEvent parseEvent(TmfContext context) {
        TmfExperimentContext expContext;
        int lastTrace;
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        if (!context.equals(this.fExperimentContext)) {
            this.seekLocation((ITmfLocation)context.getLocation());
        }
        if ((lastTrace = (expContext = (TmfExperimentContext)context).getLastTrace()) != -1) {
            TmfContext traceContext = expContext.getContexts()[lastTrace];
            expContext.getEvents()[lastTrace] = expContext.getTraces()[lastTrace].getNextEvent(traceContext);
            expContext.setLastTrace(-1);
            this.fExperimentContext = (TmfExperimentContext)context;
        }
        int trace = -1;
        TmfTimestamp timestamp = TmfTimestamp.BigCrunch;
        int i = 0;
        while (i < expContext.getTraces().length) {
            TmfTimestamp otherTS;
            TmfEvent event = expContext.getEvents()[i];
            if (event != null && event.getTimestamp() != null && (otherTS = event.getTimestamp()).compareTo(timestamp, true) < 0) {
                trace = i;
                timestamp = otherTS;
            }
            ++i;
        }
        TmfEvent event = null;
        if (trace != -1) {
            event = expContext.getEvents()[trace];
        }
        return event;
    }

    public String toString() {
        return "[TmfExperiment (" + this.getName() + ")]";
    }

    protected void indexExperiment(boolean waitForCompletion) {
        final Job job = new Job("Indexing " + this.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.fCheckpoints.clear();
        TmfEventRequest<TmfEvent> request = new TmfEventRequest<TmfEvent>(TmfEvent.class, TmfTimeRange.Eternity, Integer.MAX_VALUE, this.fIndexPageSize, ITmfDataRequest.ExecutionType.BACKGROUND){
            TmfTimestamp startTime;
            TmfTimestamp lastTime;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.startTime = null;
                this.lastTime = null;
            }

            @Override
            public void handleData(TmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    TmfTimestamp ts = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = new TmfTimestamp(ts);
                    }
                    this.lastTime = new TmfTimestamp(ts);
                    if (this.getNbRead() % TmfExperiment.this.fIndexPageSize == 0) {
                        this.updateExperiment();
                    }
                }
            }

            @Override
            public void handleSuccess() {
                this.updateExperiment();
                super.handleSuccess();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
            }

            private void updateExperiment() {
                int nbRead = this.getNbRead();
                if (nbRead != 0) {
                    TmfExperiment.this.fTimeRange = new TmfTimeRange(this.startTime, new TmfTimestamp(this.lastTime));
                    TmfExperiment.this.fNbEvents = nbRead;
                    TmfExperiment.this.notifyListeners();
                }
            }
        };
        this.sendRequest(request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyListeners() {
        this.broadcast(new TmfExperimentUpdatedSignal((Object)this, this));
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<T> signal) {
        TmfExperiment<TmfEvent> experiment = signal.getExperiment();
        if (experiment == this) {
            TmfExperiment.setCurrentExperiment(experiment);
            this.indexExperiment(false);
        } else {
            this.dispose();
        }
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        TmfExperiment tmfExperiment = this;
        synchronized (tmfExperiment) {
            this.updateNbEvents();
            this.updateTimeRange();
        }
        this.broadcast(new TmfExperimentUpdatedSignal((Object)this, this));
    }

    @Override
    protected void queueBackgroundRequest(ITmfDataRequest<T> request, final int blockSize, final boolean indexing) {
        if (!(request instanceof ITmfEventRequest)) {
            super.queueRequest(request);
            return;
        }
        final ITmfEventRequest eventRequest = (ITmfEventRequest)request;
        Thread thread = new Thread(){

            @Override
            public void run() {
                final Integer[] CHUNK_SIZE = new Integer[]{blockSize + (indexing ? 1 : 0)};
                final Integer[] nbRead = new Integer[]{0};
                final Boolean[] isFinished = new Boolean[]{Boolean.FALSE};
                while (!isFinished[0].booleanValue()) {
                    TmfDataRequest subRequest = new TmfDataRequest<T>(eventRequest.getDataType(), nbRead[0], CHUNK_SIZE[0], blockSize, ITmfDataRequest.ExecutionType.BACKGROUND){

                        @Override
                        public void handleData(T data) {
                            super.handleData(data);
                            eventRequest.handleData(data);
                            if (this.getNbRead() == CHUNK_SIZE[0].intValue()) {
                                nbRead[0] = nbRead[0] + this.getNbRead();
                            }
                            if (this.getNbRead() > CHUNK_SIZE[0]) {
                                System.out.println("ERROR - Read too many events");
                            }
                        }

                        @Override
                        public void handleCompleted() {
                            if (this.getNbRead() < CHUNK_SIZE[0]) {
                                if (this.isCancelled()) {
                                    eventRequest.cancel();
                                } else if (this.isFailed()) {
                                    eventRequest.fail();
                                } else {
                                    eventRequest.done();
                                }
                                isFinished[0] = Boolean.TRUE;
                                nbRead[0] = nbRead[0] + this.getNbRead();
                            }
                            super.handleCompleted();
                        }
                    };
                    if (isFinished[0].booleanValue()) continue;
                    TmfExperiment.this.queueRequest(subRequest);
                    try {
                        subRequest.waitForCompletion();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    CHUNK_SIZE[0] = blockSize;
                }
            }
        };
        thread.start();
    }
}

