/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.component.TmfDataProvider;
import org.eclipse.linuxtools.tmf.event.TmfData;

public class TmfProviderManager {
    private static Map<Class<? extends TmfData>, List<TmfDataProvider<? extends TmfData>>> fProviders = new HashMap<Class<? extends TmfData>, List<TmfDataProvider<? extends TmfData>>>();

    private TmfProviderManager() {
    }

    public static <T extends TmfData> void register(Class<T> eventType, TmfDataProvider<? extends TmfData> provider) {
        if (fProviders.get(eventType) == null) {
            fProviders.put(eventType, new ArrayList());
        }
        fProviders.get(eventType).add(provider);
    }

    public static <T extends TmfData> void deregister(Class<T> dataClass, TmfDataProvider<? extends TmfData> provider) {
        List<TmfDataProvider<? extends TmfData>> list = fProviders.get(dataClass);
        if (list != null) {
            list.remove(provider);
            if (list.size() == 0) {
                fProviders.remove(dataClass);
            }
        }
    }

    public static TmfDataProvider<? extends TmfData>[] getProviders(Class<? extends TmfData> dataClass) {
        List<TmfDataProvider<? extends TmfData>> list = fProviders.get(dataClass);
        if (list == null) {
            list = new ArrayList<TmfDataProvider<? extends TmfData>>();
        }
        TmfDataProvider[] result = new TmfDataProvider[list.size()];
        return list.toArray(result);
    }

    public static TmfDataProvider<? extends TmfData>[] getProviders(Class<? extends TmfData> dataClass, Class<? extends TmfDataProvider<? extends TmfData>> providerClass) {
        if (providerClass == null) {
            return TmfProviderManager.getProviders(dataClass);
        }
        TmfDataProvider<? extends TmfData>[] list = TmfProviderManager.getProviders(dataClass);
        ArrayList<TmfDataProvider<? extends TmfData>> result = new ArrayList<TmfDataProvider<? extends TmfData>>();
        if (list != null) {
            TmfDataProvider<? extends TmfData>[] tmfDataProviderArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                TmfDataProvider<? extends TmfData> provider = tmfDataProviderArray[n2];
                if (provider.getClass() == providerClass) {
                    result.add(provider);
                }
                ++n2;
            }
        }
        TmfDataProvider[] array = new TmfDataProvider[result.size()];
        return result.toArray(array);
    }
}

