/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.trace;

import org.eclipse.linuxtools.lttng.LttngException;
import org.eclipse.linuxtools.lttng.jni.exception.JniTraceVersionException;
import org.eclipse.linuxtools.lttng.jni.factory.JniTraceVersion;

public class LTTngTraceVersion {
    private String tracepath = null;
    private String traceLibPath = null;
    private JniTraceVersion traceVersion = new JniTraceVersion();

    private LTTngTraceVersion() {
    }

    public LTTngTraceVersion(String newPath, String newLibPath) throws LttngException {
        this.tracepath = newPath;
        this.traceLibPath = newLibPath;
        this.fillJniTraceVersion(this.tracepath, newLibPath);
    }

    private void fillJniTraceVersion(String newTracepath, String newTraceLibPath) throws LttngException {
        try {
            this.traceVersion.readVersionFromTrace(newTracepath, newTraceLibPath);
        }
        catch (JniTraceVersionException e) {
            throw new LttngException(e.toString());
        }
    }

    public String getTraceVersionString() {
        return this.traceVersion.getVersionAsString();
    }

    public int getTraceMinorVersion() {
        return this.traceVersion.getMinor();
    }

    public int getTraceMajorVersion() {
        return this.traceVersion.getMajor();
    }

    public float getTraceFloatVersion() {
        return this.traceVersion.getVersionAsFloat();
    }

    public boolean isValidLttngTrace() {
        return this.traceVersion.getVersionAsFloat() > 0.0f;
    }

    public String getTracepath() {
        return this.tracepath;
    }

    public void setTracepath(String newTracepath, String newLibPath) {
        try {
            this.fillJniTraceVersion(newTracepath, newLibPath);
            this.tracepath = newTracepath;
            this.traceLibPath = newLibPath;
        }
        catch (LttngException lttngException) {
            System.out.println("Could not get the trace version from the given path.Please check that the given path is a valid LTTng trace. (getTracepath)");
        }
    }

    public String toString() {
        return "LTTngTraceVersion : [" + this.getTraceFloatVersion() + "]";
    }

    public String getTraceLibPath() {
        return this.traceLibPath;
    }
}

