/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.findreplace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTableViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.findreplace.ISTFindReplaceTarget;
import org.eclipse.linuxtools.dataviewers.findreplace.STFindReplaceAction;
import org.eclipse.linuxtools.dataviewers.findreplace.STTableViewerRow;
import org.eclipse.linuxtools.dataviewers.listeners.ISpecialDrawerListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class STTableFindReplaceTarget
extends AbstractSTTableViewer
implements ISTFindReplaceTarget {
    private TableViewer _viewer = this.getViewer();
    private STFindReplaceAction action;
    private boolean scope;
    private STTableViewerRow fRow;

    public STTableFindReplaceTarget(Composite parent) {
        super(parent, 68354);
        this.addSelectionListener();
    }

    public STTableFindReplaceTarget(Composite parent, boolean init) {
        super(parent, 68354, init);
        this.addSelectionListener();
    }

    public STTableFindReplaceTarget(Composite parent, int style) {
        super(parent, style, true);
        this.addSelectionListener();
    }

    public STTableFindReplaceTarget(Composite parent, int style, boolean init) {
        super(parent, style, init);
        this.addSelectionListener();
    }

    @Override
    public boolean canPerformFind() {
        return this._viewer != null && this._viewer.getInput() != null;
    }

    @Override
    public ViewerCell findAndSelect(ViewerCell widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean wrapSearch, boolean regExSearch) {
        return this.findAndSelect(widgetOffset, findString, searchForward, searchForward, caseSensitive, wholeWord, wrapSearch, regExSearch);
    }

    @Override
    public ViewerCell getSelection(ViewerCell index) {
        if (index == null) {
            if (this.fRow != null) {
                return this.fRow.getCell(0);
            }
            this.fRow = new STTableViewerRow(this._viewer.getTable().getItem(0));
            return this.fRow.getCell(0);
        }
        return index;
    }

    @Override
    public String getSelectionText(ViewerCell index) {
        if (index == null) {
            if (this.fRow != null) {
                return this.fRow.getCell(0).getText();
            }
            this.fRow = new STTableViewerRow(this._viewer.getTable().getItem(0));
            return this.fRow.getCell(0).getText();
        }
        return index.getText();
    }

    @Override
    public Boolean isEditable() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private ViewerCell findAndSelect(ViewerCell cell, String findString, boolean searchForward, boolean direction, boolean caseSensitive, boolean wholeWord, boolean wrapSearch, boolean regExSearch) {
        block5: {
            if (cell == null) {
                return null;
            }
            dirCell = ViewerCell.RIGHT;
            if (!searchForward) {
                dirCell = ViewerCell.LEFT;
            }
            table = this._viewer.getTable();
            if ((!this.scope || table.isSelected(table.indexOf((TableItem)cell.getItem()))) && (cellFound = this.searchInRow(cell.getViewerRow(), cell.getColumnIndex(), findString, searchForward, caseSensitive, wholeWord, dirCell, regExSearch)) != null) {
                return cellFound;
            }
            dirCell = ViewerCell.RIGHT;
            dirRow = 0;
            dirRow = searchForward != false ? 2 : 1;
            row = cell.getViewerRow();
            if (table.getSelectionCount() != 0) ** GOTO lbl22
            while (row.getNeighbor(dirRow, true) != null) {
                cell = this.searchInRow(row = row.getNeighbor(dirRow, true), 0, findString, searchForward, caseSensitive, wholeWord, dirCell, regExSearch);
                if (cell == null) continue;
                return cell;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                row = row.getNeighbor(dirRow, true);
                if (this.scope && !table.isSelected(table.indexOf((TableItem)row.getItem())) || (cell = this.searchInRow(row, 0, findString, searchForward, caseSensitive, wholeWord, dirCell, regExSearch)) == null) continue;
                return cell;
lbl22:
                // 2 sources

                ** while (row.getNeighbor((int)dirRow, (boolean)true) != null)
            }
        }
        return null;
    }

    private ViewerCell searchInRow(ViewerRow row, int index, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, int dirCell, boolean regExSearch) {
        Pattern pattern = null;
        if (regExSearch) {
            pattern = Pattern.compile(findString);
        }
        ISTDataViewersField[] fields = this.getAllFields();
        ViewerCell cell = row.getCell(index);
        do {
            String text = "";
            ISTDataViewersField field = fields[cell.getColumnIndex()];
            if (field.getSpecialDrawer(cell.getElement()) != null) {
                ISpecialDrawerListener hfield = (ISpecialDrawerListener)((Object)field);
                text = hfield.getValue(cell.getElement()).trim();
            } else {
                text = cell.getText().trim();
            }
            boolean ok = false;
            if (regExSearch) {
                Matcher matcher = pattern.matcher(text);
                ok = matcher.find();
            } else if (wholeWord) {
                ok = caseSensitive ? text.equals(findString) : text.equalsIgnoreCase(findString);
            } else {
                ok = text.contains(findString);
                if (ok && caseSensitive) {
                    text.indexOf(findString);
                }
            }
            if (!ok) continue;
            this._viewer.reveal(cell.getElement());
            if (this._viewer.getTable().getSelectionCount() > 0) {
                TableViewer tv = this._viewer;
                Table table = tv.getTable();
                table.deselect(table.indexOf((TableItem)row.getItem()));
            }
            return cell;
        } while ((cell = cell.getNeighbor(dirCell, true)) != null);
        return null;
    }

    private void addSelectionListener() {
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (STTableFindReplaceTarget.this._viewer.getTable().getSelectionCount() > 0) {
                    STTableFindReplaceTarget.this.fRow = new STTableViewerRow(STTableFindReplaceTarget.this._viewer.getTable().getSelection()[0]);
                } else {
                    STTableFindReplaceTarget.this.fRow = null;
                }
            }
        });
    }

    @Override
    protected Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (STTableFindReplaceTarget.this.action != null) {
                    STTableFindReplaceTarget.this.action.setEnabled(STTableFindReplaceTarget.this.canPerformFind());
                }
            }
        });
        return table;
    }

    @Override
    public void setFindAction(STFindReplaceAction action) {
        this.action = action;
    }

    @Override
    public ViewerCell getFirstCell(ViewerCell start, int direction) {
        STTableViewerRow row = null;
        row = direction == 1 ? (this.scope && this._viewer.getTable().getSelectionCount() > 0 ? new STTableViewerRow(this._viewer.getTable().getSelection()[0]) : new STTableViewerRow(this._viewer.getTable().getItem(0))) : (this.scope && this._viewer.getTable().getSelectionCount() > 0 ? new STTableViewerRow(this._viewer.getTable().getSelection()[this._viewer.getTable().getSelection().length - 1]) : new STTableViewerRow(this._viewer.getTable().getItem(this._viewer.getTable().getItemCount() - 1)));
        return row.getCell(0);
    }

    @Override
    public void useSelectedLines(boolean use) {
        this.scope = use;
    }
}

